% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgb.DMatrix.R
\name{xgb.slice.DMatrix}
\alias{xgb.slice.DMatrix}
\alias{[.xgb.DMatrix}
\title{Slice DMatrix}
\usage{
xgb.slice.DMatrix(object, idxset, allow_groups = FALSE)

\method{[}{xgb.DMatrix}(object, idxset, colset = NULL)
}
\arguments{
\item{object}{Object of class \code{xgb.DMatrix}.}

\item{idxset}{An integer vector of indices of rows needed (base-1 indexing).}

\item{allow_groups}{Whether to allow slicing an \code{xgb.DMatrix} with \code{group} (or
equivalently \code{qid}) field. Note that in such case, the result will not have
the groups anymore - they need to be set manually through \code{\link[=setinfo]{setinfo()}}.}

\item{colset}{Currently not used (columns subsetting is not available).}
}
\description{
Get a new DMatrix containing the specified rows of original xgb.DMatrix object.
}
\examples{
data(agaricus.train, package = "xgboost")

dtrain <- with(agaricus.train, xgb.DMatrix(data, label = label, nthread = 2))

dsub <- xgb.slice.DMatrix(dtrain, 1:42)
labels1 <- getinfo(dsub, "label")

dsub <- dtrain[1:42, ]
labels2 <- getinfo(dsub, "label")
all.equal(labels1, labels2)

}
