% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rexVar.r
\name{rexVar}
\alias{rexVar}
\title{rexVar}
\usage{
rexVar(object, data, ns = 500, cint = 0.95)
}
\arguments{
\item{object}{a fit from \code{rms} or \code{rmsb}}

\item{data}{a data frame, data table, or list providing the predictors used in the original fit}

\item{ns}{maximum number of bootstrap repetitions or posterior draws to use}

\item{cint}{confidence interval coverage probability for nonparametric bootstrap percentile intervals, or probability for a Bayesian highest posterior density interval for the relative explained variations.}
}
\value{
a vector (if bootstrapping or Bayesian posterior sampling was not done) or a matrix otherwise, with rows corresponding to predictors and colums \code{REV}, \code{Lower}, \code{Upper}.  The returned object is of class \code{rexVar}.
}
\description{
Relative Explained Variation
}
\details{
Computes measures of relative explained variation for each predictor in an \code{rms} or \code{rmsb} model fit \code{object}.  This is similar to \code{plot(anova(fit), what='proportion R2')}.  For an \code{ols} model the result is exactly that.  Uncertainty intervals are computed if the model fit is from \code{rmsb} or was run through \code{\link[=bootcov]{bootcov()}} with \code{coef.reps=TRUE}.  The results may be printed, and there is also a \code{plot} method.

When \code{object} is not an \code{ols} fit, the linear predictor from the fit in \code{object} is predicted from the original predictors, resulting in a linear model with \eqn{R^{2}=1.0}.  The partial \eqn{R^2} for each predictor from a new \code{ols} fit is the relative explained variation.  The process is repeated when bootstrap coefficients repetitions or posterior draws are present, to get uncertainty intervals.  So relative explained variation is the proportion of variation in the initial model's predicted values (on the linear predictor scale) that is due to each predictor.

Nonlinear and interaction terms are pooled with main linear effect of predictors, so relative explained variation for a predictor measures its total impact on predicted values, either as main effects or effect modifiers (interaction components).
}
\examples{
set.seed(1)
n <- 100
x1 <- rnorm(n)
x2 <- rnorm(n)
x3 <- rnorm(n)
yo  <- x1 + x2 + rnorm(n) / 2.
# Minimally group y so that bootstrap samples are very unlikely to miss a
# value of y
y <- ordGroupBoot(yo)
d <- data.frame(x1, x2, x3, y)
dd <- datadist(d); options(datadist='dd')
f  <- ols(y ~ pol(x1, 2) * pol(x2, 2) + x3,
          data=d, x=TRUE, y=TRUE)
plot(anova(f), what='proportion R2', pl=FALSE)
rexVar(f)
g <- bootcov(f, B=20, coef.reps=TRUE)
rexVar(g, data=d)
f <- orm(y ~ pol(x1,2) * pol(x2, 2) + x3,
         data=d, x=TRUE, y=TRUE)
rexVar(f, data=d)
g <- bootcov(f, B=20, coef.reps=TRUE)
rexVar(g, data=d)
\dontrun{
require(rmsb)
h <- blrm(y ~ pol(x1,2) * pol(x2, 2) + x3, data=d)
rexVar(h, data=d)
}
options(datadist=NULL)
}
\seealso{
\code{\link[Hmisc:cut2]{Hmisc::cutGn()}}
}
\author{
Frank Harrell
}
