get_filename_component(_currentDir "${CMAKE_CURRENT_LIST_FILE}" PATH)
include("${_currentDir}/CheckCCompilerFlag.cmake")
include("${_currentDir}/CheckCXXCompilerFlag.cmake")
macro(AddCompilerFlag _flag)
   string(REGEX REPLACE "[-.+/:= ]" "_" _flag_esc "${_flag}")
   check_c_compiler_flag("${_flag}" check_c_compiler_flag_${_flag_esc})
   check_cxx_compiler_flag("${_flag}" check_cxx_compiler_flag_${_flag_esc})

   set(_c_flags "CMAKE_C_FLAGS")
   set(_cxx_flags "CMAKE_CXX_FLAGS")
   if(${ARGC} EQUAL 2)
      set(${ARGV1} "${check_cxx_compiler_flag_${_flag_esc}}")
   elseif(${ARGC} GREATER 2)
      set(state 0)
      unset(_c_flags)
      unset(_cxx_flags)
      foreach(_arg ${ARGN})
         if(_arg STREQUAL "C_FLAGS")
            set(state 1)
         elseif(_arg STREQUAL "CXX_FLAGS")
            set(state 2)
         elseif(_arg STREQUAL "C_RESULT")
            set(state 3)
         elseif(_arg STREQUAL "CXX_RESULT")
            set(state 4)
         elseif(state EQUAL 1)
            set(_c_flags "${_arg}")
         elseif(state EQUAL 2)
            set(_cxx_flags "${_arg}")
         elseif(state EQUAL 3)
            set(${_arg} ${check_c_compiler_flag_${_flag_esc}})
         elseif(state EQUAL 4)
            set(${_arg} ${check_cxx_compiler_flag_${_flag_esc}})
         else()
            message(FATAL_ERROR "Syntax error for AddCompilerFlag")
         endif()
      endforeach()
   endif()

   #overload the ARGC configuration of _c_flags and _cxx_flags variables
   set(_c_flags "CMAKE_C_FLAGS")
   set(_cxx_flags "CMAKE_CXX_FLAGS")

   if(check_c_compiler_flag_${_flag_esc} AND DEFINED _c_flags)
      set(${_c_flags} "${${_c_flags}} ${_flag}")
   endif()
   if(check_cxx_compiler_flag_${_flag_esc} AND DEFINED _cxx_flags)
      set(${_cxx_flags} "${${_cxx_flags}} ${_flag}")
   endif()
endmacro(AddCompilerFlag)
