
# Azure EASM Data Plane client library for Python
*Microsoft Defender External Attack Surface Management (Defender EASM)* continuously discovers and maps your digital attack surface to provide an external view of your online infrastructure. This visibility enables security and IT teams to identify unknowns, prioritize risk, eliminate threats, and extend vulnerability and exposure control beyond the firewall. Defender EASM leverages Microsoft’s crawling technology to discover assets that are related to your known online infrastructure, and actively scans these assets to discover new connections over time. Attack Surface Insights are generated by leveraging vulnerability and infrastructure data to showcase the key areas of concern for your organization.

[Source Code][source_code] | [Package (pypi)][pypi] | [Api Reference Documentation][api_reference] | [Product Documentation][product_documentation]

## Getting started
### Installing the package

#### pip
```bash
python -m pip install azure-defender-easm
```

#### from source
```bash
python setup.py intall
```

#### Prerequisites

- Python 3.7 or later is required to use this package.
- You need an [Azure subscription][azure_sub] to use this package.
- An existing EASM Data Plane Client instance.

#### Create with an Azure Active Directory Credential
To use an [Azure Active Directory (AAD) token credential][authenticate_with_token],
provide an instance of the desired credential type obtained from the
[azure-identity][azure_identity_credentials] library.

To authenticate with AAD, you must first [pip][pip] install [`azure-identity`][azure_identity_pip]

After setup, you can choose which type of [credential][azure_identity_credentials] from azure.identity to use.
As an example, [DefaultAzureCredential][default_azure_credential] can be used to authenticate the client:

Set the values of the client ID, tenant ID, and client secret of the AAD application as environment variables:
`AZURE_CLIENT_ID`, `AZURE_TENANT_ID`, `AZURE_CLIENT_SECRET`

Use the returned token credential to authenticate the client:

```python
from azure.defender.easm import EasmClient
from azure.identity import DefaultAzureCredential

sub_id = '<your subscription ID here>'
workspace_name = '<your workspace name here>'
resource_group = '<your resource group here>'
region = '<your region here>'

endpoint = f'{region}.easm.defender.microsoft.com'

client = EasmClient(endpoint, resource_group, sub_id, workspace_name, credential=DefaultAzureCredential())
```

## Key concepts
Basic understanding these terms will help to get started with EASM client library.

### [Assets][assets_documentation]
Defender EASM includes the discovery of the following kinds of assets:
-   Domains
-   Hosts
-   Pages
-   IP Blocks
-   IP Addresses
-   Autonomous System Numbers (ASNs)
-   SSL Certificates
-   WHOIS Contacts

These asset types comprise your attack surface inventory in Defender EASM. This solution discovers externally facing assets that are exposed to the open internet outside of traditional firewall protection; they need to be monitored and maintained to minimize risk and improve an organization’s security posture. Microsoft Defender External Attack Surface Management (Defender EASM) actively discovers and monitors these assets, then surfacing key insights that help customers efficiently address any vulnerabilities in their organization.

### [Discovery][discovery_documentation]
Microsoft Defender External Attack Surface Management (Defender EASM) relies on our proprietary discovery technology to continuously define your organization’s unique Internet-exposed attack surface. Discovery scans known assets owned by your organization to uncover previously unknown and unmonitored properties. Discovered assets are indexed in a customer’s inventory, providing a dynamic system of record of web applications, third party dependencies, and web infrastructure under the organization’s management through a single pane of glass.

#### [Discovery Groups][discovery_groups_documentation]
Custom discoveries are organized into Discovery Groups. They are independent seed clusters that comprise a single discovery run and operate on their own recurrence schedules. Users can elect to organize their Discovery Groups to delineate assets in whatever way best benefits their company and workflows. Common options include organizing by responsible team/business unit, brands or subsidiaries.

## Examples
After authenticating as shown in the "Create with an Azure Active Directory Credential" section, you can get started building your inventory like this:

### Create a discovery group
```python
from azure.defender.easm import EasmClient
from azure.identity import DefaultAzureCredential

sub_id = '<your subscription ID here>'
workspace_name = '<your workspace name here>'
resource_group = '<your resource group here>'
region = '<your region here>'

endpoint = f'{region}.easm.defender.microsoft.com'

client = EasmClient(endpoint, resource_group, sub_id, workspace_name, credential=DefaultAzureCredential())

client.discovery_groups.put("example group", {
	'seeds': [
	    {'kind': 'host', 'name': 'example.org'}
	]
})
client.discovery_groups.run("example group")
```

### View assets
```python
from azure.defender.easm import EasmClient
from azure.identity import DefaultAzureCredential

sub_id = '<your subscription ID here>'
workspace_name = '<your workspace name here>'
resource_group = '<your resource group here>'
region = '<your region here>'

endpoint = f'{region}.easm.defender.microsoft.com'

client = EasmClient(endpoint, resource_group, sub_id, workspace_name, credential=DefaultAzureCredential())

for asset in client.assets.list():
	print(f'{asset.kind}: {asset.name}')
```
### More examples
More examples can be viewed in the [samples directory][samples] of this repository

### Troubleshooting

### Next steps

## Contributing
This project welcomes contributions and suggestions. Most contributions require
you to agree to a Contributor License Agreement (CLA) declaring that you have
the right to, and actually do, grant us the rights to use your contribution.
For details, visit https://cla.microsoft.com.

When you submit a pull request, a CLA-bot will automatically determine whether
you need to provide a CLA and decorate the PR appropriately (e.g., label,
comment). Simply follow the instructions provided by the bot. You will only
need to do this once across all repos using our CLA.

This project has adopted the
[Microsoft Open Source Code of Conduct][code_of_conduct]. For more information,
see the Code of Conduct FAQ or contact opencode@microsoft.com with any
additional questions or comments.

<!-- LINKS -->
[code_of_conduct]: https://opensource.microsoft.com/codeofconduct/
[authenticate_with_token]: https://docs.microsoft.com/azure/cognitive-services/authentication?tabs=powershell#authenticate-with-an-authentication-token
[azure_identity_credentials]: https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/identity/azure-identity#credentials
[azure_identity_pip]: https://pypi.org/project/azure-identity/
[default_azure_credential]: https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/identity/azure-identity#defaultazurecredential
[pip]: https://pypi.org/project/pip/
[azure_sub]: https://azure.microsoft.com/free/
[samples]: https://github.com/nathanfalke/azure-sdk-for-python/tree/main/sdk/easm/azure-defender-easm/samples
[assets_documentation]: https://learn.microsoft.com/azure/external-attack-surface-management/understanding-inventory-assets
[discovery_documentation]: https://learn.microsoft.com/azure/external-attack-surface-management/what-is-discovery
[discovery_groups_documentation]: https://learn.microsoft.com/azure/external-attack-surface-management/using-and-managing-discovery#discovery-groups
[source_code]: https://github.com/Azure/azure-sdk-for-python/tree/main/sdk/easm/azure-defender-easm/
[pypi]: https://pypi.org/project/azure-defender-easm/
[api_reference]: https://review.learn.microsoft.com/rest/api/defenderforeasm/?branch=easm
[product_documentation]:  https://learn.microsoft.com/azure/external-attack-surface-management/
