#!/usr/bin/python3

import gi
import sys

gi.require_version("Gtk", "4.0")
gi.require_version("Casilda", "1.0")
from gi.repository import GLib, Gtk, Casilda


class CasildaApplication(Gtk.Application):
    def __init__(self):
        super().__init__(
            application_id="ar.xjuan.casilda.PyGObject.Example"
        )

    def do_activate(self):
        compositor = Casilda.Compositor()

        window = Gtk.ApplicationWindow(
            application=self,
            title="Casilda Compositor",
            default_width=800,
            default_height=600,
            child=compositor
        )

        compositor.spawn_async (
            None,
            ["/usr/bin/gtk4-demo"],
            None,
            GLib.SpawnFlags.DEFAULT
        )

        window.present()


if __name__ == "__main__":
    app = CasildaApplication()
    sys.exit(app.run(sys.argv))
