/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfSchemaDocument;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeDocumentStylesElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.w3c.dom.Node;

public class OdfStylesDom
extends OdfFileDom {
    private static final long serialVersionUID = 766167617530147886L;

    public OdfStylesDom(OdfSchemaDocument odfDocument, String packagePath) {
        super(odfDocument, packagePath);
    }

    @Override
    protected void initialize() {
        for (OdfDocumentNamespace name : OdfDocumentNamespace.values()) {
            this.mUriByPrefix.put(name.getPrefix(), name.getUri());
            this.mPrefixByUri.put(name.getUri(), name.getPrefix());
        }
        super.initialize();
    }

    @Override
    public OdfSchemaDocument getDocument() {
        return (OdfSchemaDocument)this.mPackageDocument;
    }

    @Override
    public OfficeDocumentStylesElement getRootElement() {
        return (OfficeDocumentStylesElement)this.getDocumentElement();
    }

    @Override
    public XPath getXPath() {
        if (this.mXPath == null) {
            this.mXPath = XPathFactory.newInstance().newXPath();
            this.mXPath.setNamespaceContext(this);
            for (OdfDocumentNamespace name : OdfDocumentNamespace.values()) {
                this.mUriByPrefix.put(name.getPrefix(), name.getUri());
                this.mPrefixByUri.put(name.getUri(), name.getPrefix());
            }
        }
        return this.mXPath;
    }

    public OdfOfficeStyles getOfficeStyles() {
        return OdfElement.findFirstChildNode(OdfOfficeStyles.class, this.getFirstChild());
    }

    public OdfOfficeAutomaticStyles getAutomaticStyles() {
        return OdfElement.findFirstChildNode(OdfOfficeAutomaticStyles.class, this.getFirstChild());
    }

    public OdfOfficeAutomaticStyles getOrCreateAutomaticStyles() {
        OdfOfficeAutomaticStyles automaticStyles = this.getAutomaticStyles();
        if (automaticStyles == null) {
            automaticStyles = this.newOdfElement(OdfOfficeAutomaticStyles.class);
            Node parent = this.getFirstChild();
            OdfElement sibling = OdfElement.findFirstChildNode(OfficeBodyElement.class, parent);
            if (sibling == null) {
                sibling = OdfElement.findFirstChildNode(OdfOfficeMasterStyles.class, parent);
            }
            if (sibling == null) {
                parent.appendChild(automaticStyles);
            } else {
                parent.insertBefore(automaticStyles, sibling);
            }
        }
        return automaticStyles;
    }
}

