/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.jarv;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.jarv.JarvConfigurationException;
import com.thaiopensource.validate.jarv.VerifierValidator;
import java.io.IOException;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class VerifierFactorySchemaReader
implements SchemaReader {
    private final VerifierFactory vf;

    public VerifierFactorySchemaReader(VerifierFactory verifierFactory) {
        this.vf = verifierFactory;
    }

    public Schema createSchema(InputSource inputSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        try {
            return new SchemaImpl(this.vf.compileSchema(inputSource));
        }
        catch (SAXException sAXException) {
            System.err.println("compileSchema threw a SAXException class " + sAXException.getClass().toString());
            if (sAXException.getException() != null) {
                System.err.println("cause has class " + sAXException.getException().getClass().toString());
            }
            throw sAXException;
        }
        catch (VerifierConfigurationException verifierConfigurationException) {
            String string;
            Exception exception;
            while (true) {
                VerifierConfigurationException verifierConfigurationException2;
                exception = verifierConfigurationException2.getCauseException();
                string = verifierConfigurationException2.getMessage();
                if (exception != null && string != null && string.equals(exception.getMessage())) {
                    string = null;
                }
                if (string != null) break;
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof SAXException) {
                    throw (SAXException)exception;
                }
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof VerifierConfigurationException)) break;
                verifierConfigurationException2 = (VerifierConfigurationException)((Object)exception);
            }
            throw new SAXException(string, exception);
        }
    }

    public Option getOption(String string) {
        return null;
    }

    private static class SchemaImpl
    extends AbstractSchema {
        final org.iso_relax.verifier.Schema schema;

        private SchemaImpl(org.iso_relax.verifier.Schema schema) {
            this.schema = schema;
        }

        public Validator createValidator(PropertyMap propertyMap) {
            try {
                return new VerifierValidator(this.schema.newVerifier(), propertyMap);
            }
            catch (VerifierConfigurationException verifierConfigurationException) {
                Exception exception = verifierConfigurationException.getCauseException();
                if (exception instanceof RuntimeException && (verifierConfigurationException.getMessage() == null || verifierConfigurationException.getMessage().equals(exception.getMessage()))) {
                    throw (RuntimeException)exception;
                }
                throw new JarvConfigurationException(verifierConfigurationException);
            }
        }
    }
}

