---
myst:
  html_meta:
    keywords: sphinx,compilation,local
---
# Compilation en local de la FAQ

Pour voir les effets des modifications qu'ils ont apportées aux fichiers sources
`.md` de la FAQ, les contributeurs doivent *a priori* :

1. attendre la fin du processus d'intégration/développement continu (lancé
   automatiquement sur notre instance GitLab lorsqu'ils les "poussent" sur le
   dépôt du projet) ;
2. aller (à nouveau) consulter en ligne sur le site
   https://faq.gutenberg-asso.fr/ les pages .`html` correspondantes
   (ré)générées.

Ces contributeurs peuvent (devraient?) préférer compiler la FAQ en local sur
leur machine car cela présente au moins trois avantages :

- ils peuvent ainsi ne publier qu'après contrôle en local des effets de leurs
  modifications ;
- pour un unique fichier modifié, la compilation ne dure que quelques secondes
  ce qui permet un contrôle rapide ;
- le "log" de la compilation permet d'avoir connaissance de certains problèmes
  (éventuellement créés par les modifications venant d'être apportées).

Pour pouvoir compiler en local la FAQ, il y a au moins deux méthodes :

1. *pas* via une image Docker ;
2. via une image Docker.

:::{attention}
Nous avons testé ces méthodes avec le système d'exploitation GNU/Linux et les
détaillons donc dans ce cadre.  Les mêmes instructions sont valables à quelques
modifications éventuelles près pour macOS.
:::

:::{todo}
Transposer pour Windows les détails (donnés pour GNU/Linux) des méthodes
permettant de compiler la FAQ en local.
:::


## Méthode n'utilisant pas d'image Docker

Cette méthode nécessite :
- l'installation de logiciels en local sur la machine du contributeur,
  et ceci principalement dans un environnement `Python` virtuel
  via `pip install` ;
- le clonage du dépôt `git` de la FAQ qui est hébergé sur
  [l'instance GitLab de GUTenberg](https://gitlab.gutenberg-asso.fr/) ;
- l'emploi de commandes (`make`, `git`) lancées dans un terminal,
  avec l'environnment virtuel `Python` activé, afin de tester en local
  puis de contribuer vos changements.

### Étapes à suivre la première fois

1. Si ce n'est déjà fait, installez `git`.
2. Si ce n'est déjà fait, installez `python` et `python3-venv`.
3. Clonez le dépôt de la FAQ.
   Ceci peut être fait de deux
   façons (voir [Édition en clonant le dépôt](#edition-en-clonant)
   pour une description plus détaillée) :
   - soit avec `ssh`, ce qui suppose un compte ouvert *et une
     clé publique enregistrée* sur notre instance GitLab :
     ```bash
     git clone ssh://git@gitlab.gutenberg-asso.fr:31022/gutenberg/faq-gut.git
     ```
   - soit avec `https`, ce qui n'est pratique sur le long terme que si le
     mécanisme du
     [`credential.helper`](https://git-scm.com/book/sv/v2/Git-Tools-Credential-Storage)
     de `git` est mis en oeuvre afin de ne pas avoir à redonner son nom
     d'utilisateur GitLab et le mot de passe associé à chaque "push" :
     ```bash
     git clone https://gitlab.gutenberg-asso.fr/gutenberg/faq-gut.git
     ```
4. Créez un environnement virtuel `python`, par exemple nommé
   `.venv` et placé dans un sous-dossier (caché) du dossier de la FAQ :
   ```bash
   python3 -m venv .venv
   ```
5. Activez l'environnement virtuel `.venv` :
   ```bash
   source .venv/bin/activate
   ```
   L'activation de l'environnement virtuel modifie le *prompt* de votre ligne de
   commande en le faisant précéder du nom choisi pour cet environnement virtuel.
6. Installez certains modules `python` nécessaires à la compilation de la FAQ
   (dont bien sûr [`Sphinx-doc`](https://www.sphinx-doc.org)) :
   ```bash
   python3 -m pip install -U pip
   python3 -m pip install    \
         Sphinx              \
         Pillow              \
         sphinx_comments     \
         sphinx_design       \
         sphinxext.opengraph \
         myst_parser         \
         linkify-it-py       \
         sphinx_tippy        \
         sphinx_sitemap      \
         pydata_sphinx_theme \
         sphinx_copybutton   \
         sphinx_togglebutton \
         sphinx_examples     \
         sphinx_last_updated_by_git
   ```
7. Installez `pygments-acetexlexer` (module `python` enrichissant le
   surligneur syntaxique `Pygments`) :
   ```bash
   python3 -m pip install git+https://gitlab.gutenberg-asso.fr/dbitouze/pygments-acetexlexer.git@main
   ```
8. Dans le dossier de la FAQ (où vous devriez vous trouver avec
   l'environnement virtuel `.venv` actif), lancez la compilation de cette
   dernière :
   ```bash
   make html
   ```
   Pour cette première fois, la compilation sera complète et donc un peu
   longue.

   :::{note}
   En principe, vous devriez obtenir le même effet avec la commande
   suivante :
   ```bash
   sphinx-build -j auto source build/html -d build/doctrees
   ```
   Mais il n'y a pas de raison de l'utiliser plutôt que `make html`.
   :::

   Vous verrez éventuellement apparaître un certain nombre de *warnings*
   signalant, comme lors d'une compilation LaTeX, de potentiels problèmes,
   dont certains peuvent être ignorés.
9. Lorsque cette compilation est achevée, vous pouvez consulter dans un
   navigateur Web la FAQ construite localement sur votre machine. Il suffit
   pour ce faire de lancer la commande (ici pour le navigateur Firefox) :
   ```bash
   firefox build/html/index.html &
   ```
   puis de naviguer dans la FAQ comme vous le feriez en ligne.

   :::{note}
   Sur macOS, utilisez `open build/html/index.html`.
   :::

### Faire des modifications et les intégrer au dépôt

Il est très important de veiller à bien réactiver l'environnement virtuel
`.venv` avant toute tentative de compilation de la FAQ en local, si vous
avez depuis la dernière fois fermé votre session ou votre terminal pour
les commandes en ligne.

Une fois rendu à nouveau dans le dossier de la FAQ, lancez, si l'environnement
virtuel n'est pas déjà actif, la commande :
```bash
source .venv/bin/activate
```

Puis, exécutez `git pull` pour intégrer les modifications distantes et
`make html` pour mettre à jour les fichiers `html` (ces
fichiers bien sûr ne sont pas intégrés au contrôle de version `git`, seuls
ceux du répertoire `source`, et quelques autres d'une nature technique, le
sont).

Vous pouvez alors commencer à apporter des modifications à un ou plusieurs
fichiers sources `.md` du dossier `source`.  Pour vous entraîner "à blanc",
vous pouvez modifier le fichier `source/8_contribuer/bac-a-sable.md`, si vous
craignez de casser quelque chose.

Testez vos modifications par `make html`.  Seuls les fichiers `html` impactés
par les modifications seront reconstruits et le processus devrait a priori
être rapide.

Lorsque vos modifications vous conviennent, vous pouvez en faire un "commit"
avec les commandes usuelles du type `git commit -a`.  Si au contraire vous
voulez vous en débarrasser faites `git stash` puis éventuellement `git stash
drop`.  Si vous avez déjà fait des commits en local et que leur organisation
ne convient pas vous pouvez exécuter `git reset origin/main` pour conserver
les fichiers modifiés mais annuler les commits associés.  Ou `git reset --hard
origin/main` pour tout oublier et annuler totalement vos modifications.

Une fois vos commits satisfaisants il suffira de `git push` pour les "pousser"
sur le dépôt de la FAQ.  Vos modifications apparaîtront en ligne au plus tard
quelques minutes après.

:::{hint}
Plus précisément, deux possibilités avec le `git push` :
- la procédure aboutit,
- ou le dépôt de la FAQ a été modifié entre-temps, et le "push" ne peut
  aboutir.

Dans ce dernier cas :
- `git fetch` pour récupérer les modifications distantes dans `origin/main`,
- puis `git rebase origin/main` pour que votre
  branche `main` locale soit un descendant de la branche `main` du dépôt.
- `git push` pourra alors (enfin !) mettre à jour le dépôt avec vos
  propres modifications.

Dans certains cas l'étape `git rebase` après le `git fetch` aura donné lieu à
des conflits car des modifications distantes seront rentrées en collision avec
celles apportées par vos soins.  La résolution de ces conflits est la routine
pour les utilisateurs expérimentés de `git`, mais il faut donc une certaine
expérience avec `git` pour fonctionner suivant ces mécanismes.

Les commandes comme `git merge` créent un historique plus embrouillé et moins
linéaire et il est donc toujours préférable de procéder par `git rebase
origin/main` depuis votre branche `main` ayant des commits supplémentaires,
puis `git push`.
:::
    
## Méthode utilisant une image Docker

:::{todo} Compléter la méthode utilisant une image Docker pour compiler la FAQ
en local.
:::
