---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, notes de bas de page, fin de document
---

# Comment mettre les notes de bas de page en fin de document ?

L'extension <ctanpkg:endnotes> s'occupe ici de tout avec des commandes dédiées :
- `\endnote{⟨texte de la note⟩}` insére une marque de note dans le texte 
  et prépare le `⟨texte de la note⟩` pour sa mise en fin de document ;
- `\theendnotes` génére la liste des notes de fin de document.

La [documentation](texdoc:endnotes) de l'extension propose ici une astuce 
pour que des commandes `\footnote` se comportent comme des commandes `\endnote`,
évitant ainsi de passer en revue tout un document. 
Elle remplace la définition de l'une par la définition de l'autre 
avec la commande `\let` de TeX. En voici un exemple.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{endnotes} 
  
  \let\footnote=\endnote % Astuce de la documentation de endnotes.

\begin{document}
\section{Le début}
Voici donc que le texte amène à un premier commentaire\footnote{Guère 
utile} puis, de façon inopinée, à un second\footnote{Encore moins 
utile.}.

\newpage % Changement de page pour notre exemple
\section{La fin}
Le lecteur éclairé pourra sans doute se poser des 
questions\footnote{Pertinentes.} sur le texte même de cet exemple.

\newpage % Changement de page pour notre exemple
\theendnotes
\end{document}
```

Cette extension présente d'autres commandes permettant des réglages plus fins 
sur ce sujet.