/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef _UTILS
#define _UTILS

template <typename T> inline bool inrange (const T& min, const T& val, const T& max) {
  return ((val >= min) && (val <= max));
}

template<typename T> inline T& clamp (const T& lo, T& val, const T& hi) {

  // ensures lo <= val <= hi
  if (val < lo) val = lo; else if (val > hi) val = hi;
  return val;

}
#endif
