#!/usr/bin/perl -w

eval 'exec perl -S $0 ${1+"$@"}'
    if 0;

# This script will create the Makefile to build and install a graphical
# user interface for CLC-INTERCAL

# This file is part of CLC-INTERCAL

# Copyright (c) 2008, 2023-2024 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

require 5.005;
use strict;
use File::Spec::Functions qw(catfile updir);

use vars qw($VERSION $PERVERSION);
($VERSION) = ($PERVERSION = "CLC-INTERCAL/UI-X Makefile.PL 1.00") =~ /\s(\S+)$/;

my $in_bundle;
my @av = map { /^--in-bundle=(.*)$/ ? ($1) : () } @ARGV;
if (@av) {
    $in_bundle = shift @av;
    @ARGV = grep { ! /^--in-bundle=/ } @ARGV;
}

my $reqv = '1.-94.-2.4';
for my $module (qw(InstallModule Exporter)) {
    if (defined $in_bundle) {
	eval {
	    require (catfile(updir(), $in_bundle, 'INTERCAL', "$module.pm"));
	    eval "import Language::INTERCAL::$module '$reqv';";
	    die $@ if $@;
	};
    } else {
	eval "use Language::INTERCAL::$module '$reqv';";
    }
    if ($@) {
	$@ =~ /can't locate/i and die "You don't appear to have CLC-INTERCAL installed:\n$@";
	die "Error loading the CLC-INTERCAL installer:\n$@";
    }
}

$in_bundle and Language::INTERCAL::InstallModule::in_bundle($in_bundle);

my $Gtk;
BEGIN {
    eval {
	require Gtk3;
	import Gtk3;
	$Gtk = 'Gtk3';
    };
    defined $Gtk or eval {
	require Gtk2;
	import Gtk2;
	$Gtk = 'Gtk2';
    };
};
defined $Gtk or $Gtk = 'Gtk3'; # make the warning message request Gtk3

install Language::INTERCAL::InstallModule 'UI-X',
    prereq => {
	$Gtk => 0,
    };

1;
