/*
 * Copyright 2020-2021 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 */

#ifndef DCFG_LSCH3_H
#define DCFG_LSCH3_H

/* dcfg block register offsets and bitfields */
#define DCFG_PORSR1_OFFSET			0x00

#define DCFG_DEVDISR1_OFFSET			0x70
#define DCFG_DEVDISR1_SEC	(1 << 22)

#define DCFG_DEVDISR2_OFFSET			0x74

#define DCFG_DEVDISR3_OFFSET			0x78
#define DCFG_DEVDISR3_QBMAIN	(1 << 12)

#define DCFG_DEVDISR4_OFFSET			0x7C
#define DCFG_DEVDISR4_SPI_QSPI	(1 << 4 | 1 << 5)

#define DCFG_DEVDISR5_OFFSET			0x80
#define DISR5_DDRC1_MASK	0x1
#define DISR5_DDRC2_MASK	0x2
#define DISR5_OCRAM_MASK	0x1000
#define DEVDISR5_MASK_ALL_MEM	0x00001003
#define DEVDISR5_MASK_DDR	0x00000003
#define DEVDISR5_MASK_DBG	0x00000400

#define DCFG_DEVDISR6_OFFSET			0x84
//#define DEVDISR6_MASK             0x00000001

#define DCFG_COREDISR_OFFSET			0x94

#define DCFG_SVR_OFFSET				0x0A4
#define SVR_MFR_ID_MASK		0xF0000000
#define SVR_MFR_ID_SHIFT	28
#define SVR_FAMILY_MASK		0xF000000
#define SVR_FAMILY_SHIFT	24
#define SVR_DEV_ID_MASK		0x3F0000
#define SVR_DEV_ID_SHIFT	16
#define SVR_PERSONALITY_MASK	0x3E00
#define SVR_PERSONALITY_SHIFT	9
#define SVR_SEC_MASK		0x100
#define SVR_SEC_SHIFT		8
#define SVR_MAJ_VER_MASK	0xF0
#define SVR_MAJ_VER_SHIFT	4
#define SVR_MIN_VER_MASK	0xF

#define RCWSR0_OFFSET				0x100
#define RCWSR0_SYS_PLL_RAT_SHIFT	2
#define RCWSR0_SYS_PLL_RAT_MASK		0x1f
#define RCWSR0_MEM_PLL_RAT_SHIFT	10
#define RCWSR0_MEM_PLL_RAT_MASK		0x3f
#define RCWSR0_MEM2_PLL_RAT_SHIFT	18
#define RCWSR0_MEM2_PLL_RAT_MASK	0x3f

#define RCWSR5_OFFSET				0x110
#define RCWSR9_OFFSET				0x120
#define RCWSR_SB_EN_OFFSET	RCWSR9_OFFSET
#define RCWSR_SBEN_MASK		0x1
#define RCWSR_SBEN_SHIFT	10

#define RCW_SR27_OFFSET				0x168
/* DCFG register to dump error code */
#define DCFG_SCRATCH4_OFFSET			0x20C
#define DCFG_SCRATCHRW5_OFFSET			0x210
#define DCFG_SCRATCHRW6_OFFSET			0x214
#define DCFG_SCRATCHRW7_OFFSET			0x218
#define DCFG_BOOTLOCPTRL_OFFSET			0x400
#define DCFG_BOOTLOCPTRH_OFFSET			0x404
#define DCFG_COREDISABLEDSR_OFFSET		0x990

/* Reset module bit field */
#define RSTCR_RESET_REQ         0x2

#endif /*	DCFG_LSCH3_H	*/
