/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.jena.mem.test;

import org.apache.jena.mem.* ;
import org.apache.jena.rdf.model.test.ModelTestBase ;

public class TestHashedBunchMap extends ModelTestBase
    { // TODO should extend this a lot
    public TestHashedBunchMap( String name )
        { super( name ); }
    
    public void testSize()
        {
        HashCommon<Object> b = new HashedBunchMap();
        }

    public void testClearSetsSizeToZero()
        {
        TripleBunch a = new ArrayBunch();
        HashedBunchMap b = new HashedBunchMap();
        b.clear();
        assertEquals( 0, b.size() );
        b.put( "key",  a );
        assertEquals( 1, b.size() );
        b.clear();
        assertEquals( 0, b.size() );
        }
    }
