// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from cl.xml and cl_angle_ext.xml.
//
// Copyright 2025 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_cl_autogen.h:
//   Capture functions for the OpenCL  entry points.

#ifndef LIBANGLE_CAPTURE_CL_AUTOGEN_H_
#define LIBANGLE_CAPTURE_CL_AUTOGEN_H_

#include "common/PackedEnums.h"
#include "libANGLE/capture/FrameCapture.h"
#ifdef ANGLE_ENABLE_CL
#    include "common/PackedCLEnums_autogen.h"
#endif

namespace cl
{

// Method Captures

// CL 1.0
angle::CallCapture CaptureGetPlatformIDs(bool isCallValid,
                                         cl_uint num_entries,
                                         cl_platform_id *platforms,
                                         cl_uint *num_platforms,
                                         cl_int returnValue);
angle::CallCapture CaptureGetPlatformInfo(bool isCallValid,
                                          cl_platform_id platform,
                                          PlatformInfo param_namePacked,
                                          size_t param_value_size,
                                          void *param_value,
                                          size_t *param_value_size_ret,
                                          cl_int returnValue);
angle::CallCapture CaptureGetDeviceIDs(bool isCallValid,
                                       cl_platform_id platform,
                                       DeviceType device_typePacked,
                                       cl_uint num_entries,
                                       cl_device_id *devices,
                                       cl_uint *num_devices,
                                       cl_int returnValue);
angle::CallCapture CaptureGetDeviceInfo(bool isCallValid,
                                        cl_device_id device,
                                        DeviceInfo param_namePacked,
                                        size_t param_value_size,
                                        void *param_value,
                                        size_t *param_value_size_ret,
                                        cl_int returnValue);
angle::CallCapture CaptureCreateContext(bool isCallValid,
                                        const cl_context_properties *properties,
                                        cl_uint num_devices,
                                        const cl_device_id *devices,
                                        void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                                      const void *private_info,
                                                                      size_t cb,
                                                                      void *user_data),
                                        void *user_data,
                                        cl_int *errcode_ret,
                                        cl_context returnValue);
angle::CallCapture CaptureCreateContextFromType(
    bool isCallValid,
    const cl_context_properties *properties,
    DeviceType device_typePacked,
    void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                  const void *private_info,
                                  size_t cb,
                                  void *user_data),
    void *user_data,
    cl_int *errcode_ret,
    cl_context returnValue);
angle::CallCapture CaptureRetainContext(bool isCallValid, cl_context context, cl_int returnValue);
angle::CallCapture CaptureReleaseContext(bool isCallValid, cl_context context, cl_int returnValue);
angle::CallCapture CaptureGetContextInfo(bool isCallValid,
                                         cl_context context,
                                         ContextInfo param_namePacked,
                                         size_t param_value_size,
                                         void *param_value,
                                         size_t *param_value_size_ret,
                                         cl_int returnValue);
angle::CallCapture CaptureRetainCommandQueue(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_int returnValue);
angle::CallCapture CaptureReleaseCommandQueue(bool isCallValid,
                                              cl_command_queue command_queue,
                                              cl_int returnValue);
angle::CallCapture CaptureGetCommandQueueInfo(bool isCallValid,
                                              cl_command_queue command_queue,
                                              CommandQueueInfo param_namePacked,
                                              size_t param_value_size,
                                              void *param_value,
                                              size_t *param_value_size_ret,
                                              cl_int returnValue);
angle::CallCapture CaptureCreateBuffer(bool isCallValid,
                                       cl_context context,
                                       MemFlags flagsPacked,
                                       size_t size,
                                       void *host_ptr,
                                       cl_int *errcode_ret,
                                       cl_mem returnValue);
angle::CallCapture CaptureRetainMemObject(bool isCallValid, cl_mem memobj, cl_int returnValue);
angle::CallCapture CaptureReleaseMemObject(bool isCallValid, cl_mem memobj, cl_int returnValue);
angle::CallCapture CaptureGetSupportedImageFormats(bool isCallValid,
                                                   cl_context context,
                                                   MemFlags flagsPacked,
                                                   MemObjectType image_typePacked,
                                                   cl_uint num_entries,
                                                   cl_image_format *image_formats,
                                                   cl_uint *num_image_formats,
                                                   cl_int returnValue);
angle::CallCapture CaptureGetMemObjectInfo(bool isCallValid,
                                           cl_mem memobj,
                                           MemInfo param_namePacked,
                                           size_t param_value_size,
                                           void *param_value,
                                           size_t *param_value_size_ret,
                                           cl_int returnValue);
angle::CallCapture CaptureGetImageInfo(bool isCallValid,
                                       cl_mem image,
                                       ImageInfo param_namePacked,
                                       size_t param_value_size,
                                       void *param_value,
                                       size_t *param_value_size_ret,
                                       cl_int returnValue);
angle::CallCapture CaptureRetainSampler(bool isCallValid, cl_sampler sampler, cl_int returnValue);
angle::CallCapture CaptureReleaseSampler(bool isCallValid, cl_sampler sampler, cl_int returnValue);
angle::CallCapture CaptureGetSamplerInfo(bool isCallValid,
                                         cl_sampler sampler,
                                         SamplerInfo param_namePacked,
                                         size_t param_value_size,
                                         void *param_value,
                                         size_t *param_value_size_ret,
                                         cl_int returnValue);
angle::CallCapture CaptureCreateProgramWithSource(bool isCallValid,
                                                  cl_context context,
                                                  cl_uint count,
                                                  const char **strings,
                                                  const size_t *lengths,
                                                  cl_int *errcode_ret,
                                                  cl_program returnValue);
angle::CallCapture CaptureCreateProgramWithBinary(bool isCallValid,
                                                  cl_context context,
                                                  cl_uint num_devices,
                                                  const cl_device_id *device_list,
                                                  const size_t *lengths,
                                                  const unsigned char **binaries,
                                                  cl_int *binary_status,
                                                  cl_int *errcode_ret,
                                                  cl_program returnValue);
angle::CallCapture CaptureRetainProgram(bool isCallValid, cl_program program, cl_int returnValue);
angle::CallCapture CaptureReleaseProgram(bool isCallValid, cl_program program, cl_int returnValue);
angle::CallCapture CaptureBuildProgram(bool isCallValid,
                                       cl_program program,
                                       cl_uint num_devices,
                                       const cl_device_id *device_list,
                                       const char *options,
                                       void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                     void *user_data),
                                       void *user_data,
                                       cl_int returnValue);
angle::CallCapture CaptureGetProgramInfo(bool isCallValid,
                                         cl_program program,
                                         ProgramInfo param_namePacked,
                                         size_t param_value_size,
                                         void *param_value,
                                         size_t *param_value_size_ret,
                                         cl_int returnValue);
angle::CallCapture CaptureGetProgramBuildInfo(bool isCallValid,
                                              cl_program program,
                                              cl_device_id device,
                                              ProgramBuildInfo param_namePacked,
                                              size_t param_value_size,
                                              void *param_value,
                                              size_t *param_value_size_ret,
                                              cl_int returnValue);
angle::CallCapture CaptureCreateKernel(bool isCallValid,
                                       cl_program program,
                                       const char *kernel_name,
                                       cl_int *errcode_ret,
                                       cl_kernel returnValue);
angle::CallCapture CaptureCreateKernelsInProgram(bool isCallValid,
                                                 cl_program program,
                                                 cl_uint num_kernels,
                                                 cl_kernel *kernels,
                                                 cl_uint *num_kernels_ret,
                                                 cl_int returnValue);
angle::CallCapture CaptureRetainKernel(bool isCallValid, cl_kernel kernel, cl_int returnValue);
angle::CallCapture CaptureReleaseKernel(bool isCallValid, cl_kernel kernel, cl_int returnValue);
angle::CallCapture CaptureSetKernelArg(bool isCallValid,
                                       cl_kernel kernel,
                                       cl_uint arg_index,
                                       size_t arg_size,
                                       const void *arg_value,
                                       cl_int returnValue);
angle::CallCapture CaptureGetKernelInfo(bool isCallValid,
                                        cl_kernel kernel,
                                        KernelInfo param_namePacked,
                                        size_t param_value_size,
                                        void *param_value,
                                        size_t *param_value_size_ret,
                                        cl_int returnValue);
angle::CallCapture CaptureGetKernelWorkGroupInfo(bool isCallValid,
                                                 cl_kernel kernel,
                                                 cl_device_id device,
                                                 KernelWorkGroupInfo param_namePacked,
                                                 size_t param_value_size,
                                                 void *param_value,
                                                 size_t *param_value_size_ret,
                                                 cl_int returnValue);
angle::CallCapture CaptureWaitForEvents(bool isCallValid,
                                        cl_uint num_events,
                                        const cl_event *event_list,
                                        cl_int returnValue);
angle::CallCapture CaptureGetEventInfo(bool isCallValid,
                                       cl_event event,
                                       EventInfo param_namePacked,
                                       size_t param_value_size,
                                       void *param_value,
                                       size_t *param_value_size_ret,
                                       cl_int returnValue);
angle::CallCapture CaptureRetainEvent(bool isCallValid, cl_event event, cl_int returnValue);
angle::CallCapture CaptureReleaseEvent(bool isCallValid, cl_event event, cl_int returnValue);
angle::CallCapture CaptureGetEventProfilingInfo(bool isCallValid,
                                                cl_event event,
                                                ProfilingInfo param_namePacked,
                                                size_t param_value_size,
                                                void *param_value,
                                                size_t *param_value_size_ret,
                                                cl_int returnValue);
angle::CallCapture CaptureFlush(bool isCallValid,
                                cl_command_queue command_queue,
                                cl_int returnValue);
angle::CallCapture CaptureFinish(bool isCallValid,
                                 cl_command_queue command_queue,
                                 cl_int returnValue);
angle::CallCapture CaptureEnqueueReadBuffer(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_mem buffer,
                                            cl_bool blocking_read,
                                            size_t offset,
                                            size_t size,
                                            void *ptr,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int returnValue);
angle::CallCapture CaptureEnqueueWriteBuffer(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_mem buffer,
                                             cl_bool blocking_write,
                                             size_t offset,
                                             size_t size,
                                             const void *ptr,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             cl_int returnValue);
angle::CallCapture CaptureEnqueueCopyBuffer(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_mem src_buffer,
                                            cl_mem dst_buffer,
                                            size_t src_offset,
                                            size_t dst_offset,
                                            size_t size,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int returnValue);
angle::CallCapture CaptureEnqueueReadImage(bool isCallValid,
                                           cl_command_queue command_queue,
                                           cl_mem image,
                                           cl_bool blocking_read,
                                           const size_t *origin,
                                           const size_t *region,
                                           size_t row_pitch,
                                           size_t slice_pitch,
                                           void *ptr,
                                           cl_uint num_events_in_wait_list,
                                           const cl_event *event_wait_list,
                                           cl_event *event,
                                           cl_int returnValue);
angle::CallCapture CaptureEnqueueWriteImage(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_mem image,
                                            cl_bool blocking_write,
                                            const size_t *origin,
                                            const size_t *region,
                                            size_t input_row_pitch,
                                            size_t input_slice_pitch,
                                            const void *ptr,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int returnValue);
angle::CallCapture CaptureEnqueueCopyImage(bool isCallValid,
                                           cl_command_queue command_queue,
                                           cl_mem src_image,
                                           cl_mem dst_image,
                                           const size_t *src_origin,
                                           const size_t *dst_origin,
                                           const size_t *region,
                                           cl_uint num_events_in_wait_list,
                                           const cl_event *event_wait_list,
                                           cl_event *event,
                                           cl_int returnValue);
angle::CallCapture CaptureEnqueueCopyImageToBuffer(bool isCallValid,
                                                   cl_command_queue command_queue,
                                                   cl_mem src_image,
                                                   cl_mem dst_buffer,
                                                   const size_t *src_origin,
                                                   const size_t *region,
                                                   size_t dst_offset,
                                                   cl_uint num_events_in_wait_list,
                                                   const cl_event *event_wait_list,
                                                   cl_event *event,
                                                   cl_int returnValue);
angle::CallCapture CaptureEnqueueCopyBufferToImage(bool isCallValid,
                                                   cl_command_queue command_queue,
                                                   cl_mem src_buffer,
                                                   cl_mem dst_image,
                                                   size_t src_offset,
                                                   const size_t *dst_origin,
                                                   const size_t *region,
                                                   cl_uint num_events_in_wait_list,
                                                   const cl_event *event_wait_list,
                                                   cl_event *event,
                                                   cl_int returnValue);
angle::CallCapture CaptureEnqueueMapBuffer(bool isCallValid,
                                           cl_command_queue command_queue,
                                           cl_mem buffer,
                                           cl_bool blocking_map,
                                           MapFlags map_flagsPacked,
                                           size_t offset,
                                           size_t size,
                                           cl_uint num_events_in_wait_list,
                                           const cl_event *event_wait_list,
                                           cl_event *event,
                                           cl_int *errcode_ret,
                                           void *returnValue);
angle::CallCapture CaptureEnqueueMapImage(bool isCallValid,
                                          cl_command_queue command_queue,
                                          cl_mem image,
                                          cl_bool blocking_map,
                                          MapFlags map_flagsPacked,
                                          const size_t *origin,
                                          const size_t *region,
                                          size_t *image_row_pitch,
                                          size_t *image_slice_pitch,
                                          cl_uint num_events_in_wait_list,
                                          const cl_event *event_wait_list,
                                          cl_event *event,
                                          cl_int *errcode_ret,
                                          void *returnValue);
angle::CallCapture CaptureEnqueueUnmapMemObject(bool isCallValid,
                                                cl_command_queue command_queue,
                                                cl_mem memobj,
                                                void *mapped_ptr,
                                                cl_uint num_events_in_wait_list,
                                                const cl_event *event_wait_list,
                                                cl_event *event,
                                                cl_int returnValue);
angle::CallCapture CaptureEnqueueNDRangeKernel(bool isCallValid,
                                               cl_command_queue command_queue,
                                               cl_kernel kernel,
                                               cl_uint work_dim,
                                               const size_t *global_work_offset,
                                               const size_t *global_work_size,
                                               const size_t *local_work_size,
                                               cl_uint num_events_in_wait_list,
                                               const cl_event *event_wait_list,
                                               cl_event *event,
                                               cl_int returnValue);
angle::CallCapture CaptureEnqueueNativeKernel(bool isCallValid,
                                              cl_command_queue command_queue,
                                              void(CL_CALLBACK *user_func)(void *),
                                              void *args,
                                              size_t cb_args,
                                              cl_uint num_mem_objects,
                                              const cl_mem *mem_list,
                                              const void **args_mem_loc,
                                              cl_uint num_events_in_wait_list,
                                              const cl_event *event_wait_list,
                                              cl_event *event,
                                              cl_int returnValue);
angle::CallCapture CaptureSetCommandQueueProperty(bool isCallValid,
                                                  cl_command_queue command_queue,
                                                  CommandQueueProperties propertiesPacked,
                                                  cl_bool enable,
                                                  cl_command_queue_properties *old_properties,
                                                  cl_int returnValue);
angle::CallCapture CaptureCreateImage2D(bool isCallValid,
                                        cl_context context,
                                        MemFlags flagsPacked,
                                        const cl_image_format *image_format,
                                        size_t image_width,
                                        size_t image_height,
                                        size_t image_row_pitch,
                                        void *host_ptr,
                                        cl_int *errcode_ret,
                                        cl_mem returnValue);
angle::CallCapture CaptureCreateImage3D(bool isCallValid,
                                        cl_context context,
                                        MemFlags flagsPacked,
                                        const cl_image_format *image_format,
                                        size_t image_width,
                                        size_t image_height,
                                        size_t image_depth,
                                        size_t image_row_pitch,
                                        size_t image_slice_pitch,
                                        void *host_ptr,
                                        cl_int *errcode_ret,
                                        cl_mem returnValue);
angle::CallCapture CaptureEnqueueMarker(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_event *event,
                                        cl_int returnValue);
angle::CallCapture CaptureEnqueueWaitForEvents(bool isCallValid,
                                               cl_command_queue command_queue,
                                               cl_uint num_events,
                                               const cl_event *event_list,
                                               cl_int returnValue);
angle::CallCapture CaptureEnqueueBarrier(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_int returnValue);
angle::CallCapture CaptureUnloadCompiler(bool isCallValid, cl_int returnValue);
angle::CallCapture CaptureGetExtensionFunctionAddress(bool isCallValid,
                                                      const char *func_name,
                                                      void *returnValue);
angle::CallCapture CaptureCreateCommandQueue(bool isCallValid,
                                             cl_context context,
                                             cl_device_id device,
                                             CommandQueueProperties propertiesPacked,
                                             cl_int *errcode_ret,
                                             cl_command_queue returnValue);
angle::CallCapture CaptureCreateSampler(bool isCallValid,
                                        cl_context context,
                                        cl_bool normalized_coords,
                                        AddressingMode addressing_modePacked,
                                        FilterMode filter_modePacked,
                                        cl_int *errcode_ret,
                                        cl_sampler returnValue);
angle::CallCapture CaptureEnqueueTask(bool isCallValid,
                                      cl_command_queue command_queue,
                                      cl_kernel kernel,
                                      cl_uint num_events_in_wait_list,
                                      const cl_event *event_wait_list,
                                      cl_event *event,
                                      cl_int returnValue);

// CL 1.1
angle::CallCapture CaptureCreateSubBuffer(bool isCallValid,
                                          cl_mem buffer,
                                          MemFlags flagsPacked,
                                          cl_buffer_create_type buffer_create_type,
                                          const void *buffer_create_info,
                                          cl_int *errcode_ret,
                                          cl_mem returnValue);
angle::CallCapture CaptureSetMemObjectDestructorCallback(
    bool isCallValid,
    cl_mem memobj,
    void(CL_CALLBACK *pfn_notify)(cl_mem memobj, void *user_data),
    void *user_data,
    cl_int returnValue);
angle::CallCapture CaptureCreateUserEvent(bool isCallValid,
                                          cl_context context,
                                          cl_int *errcode_ret,
                                          cl_event returnValue);
angle::CallCapture CaptureSetUserEventStatus(bool isCallValid,
                                             cl_event event,
                                             cl_int execution_status,
                                             cl_int returnValue);
angle::CallCapture CaptureSetEventCallback(
    bool isCallValid,
    cl_event event,
    cl_int command_exec_callback_type,
    void(CL_CALLBACK *pfn_notify)(cl_event event, cl_int event_command_status, void *user_data),
    void *user_data,
    cl_int returnValue);
angle::CallCapture CaptureEnqueueReadBufferRect(bool isCallValid,
                                                cl_command_queue command_queue,
                                                cl_mem buffer,
                                                cl_bool blocking_read,
                                                const size_t *buffer_origin,
                                                const size_t *host_origin,
                                                const size_t *region,
                                                size_t buffer_row_pitch,
                                                size_t buffer_slice_pitch,
                                                size_t host_row_pitch,
                                                size_t host_slice_pitch,
                                                void *ptr,
                                                cl_uint num_events_in_wait_list,
                                                const cl_event *event_wait_list,
                                                cl_event *event,
                                                cl_int returnValue);
angle::CallCapture CaptureEnqueueWriteBufferRect(bool isCallValid,
                                                 cl_command_queue command_queue,
                                                 cl_mem buffer,
                                                 cl_bool blocking_write,
                                                 const size_t *buffer_origin,
                                                 const size_t *host_origin,
                                                 const size_t *region,
                                                 size_t buffer_row_pitch,
                                                 size_t buffer_slice_pitch,
                                                 size_t host_row_pitch,
                                                 size_t host_slice_pitch,
                                                 const void *ptr,
                                                 cl_uint num_events_in_wait_list,
                                                 const cl_event *event_wait_list,
                                                 cl_event *event,
                                                 cl_int returnValue);
angle::CallCapture CaptureEnqueueCopyBufferRect(bool isCallValid,
                                                cl_command_queue command_queue,
                                                cl_mem src_buffer,
                                                cl_mem dst_buffer,
                                                const size_t *src_origin,
                                                const size_t *dst_origin,
                                                const size_t *region,
                                                size_t src_row_pitch,
                                                size_t src_slice_pitch,
                                                size_t dst_row_pitch,
                                                size_t dst_slice_pitch,
                                                cl_uint num_events_in_wait_list,
                                                const cl_event *event_wait_list,
                                                cl_event *event,
                                                cl_int returnValue);

// CL 1.2
angle::CallCapture CaptureCreateSubDevices(bool isCallValid,
                                           cl_device_id in_device,
                                           const cl_device_partition_property *properties,
                                           cl_uint num_devices,
                                           cl_device_id *out_devices,
                                           cl_uint *num_devices_ret,
                                           cl_int returnValue);
angle::CallCapture CaptureRetainDevice(bool isCallValid, cl_device_id device, cl_int returnValue);
angle::CallCapture CaptureReleaseDevice(bool isCallValid, cl_device_id device, cl_int returnValue);
angle::CallCapture CaptureCreateImage(bool isCallValid,
                                      cl_context context,
                                      MemFlags flagsPacked,
                                      const cl_image_format *image_format,
                                      const cl_image_desc *image_desc,
                                      void *host_ptr,
                                      cl_int *errcode_ret,
                                      cl_mem returnValue);
angle::CallCapture CaptureCreateProgramWithBuiltInKernels(bool isCallValid,
                                                          cl_context context,
                                                          cl_uint num_devices,
                                                          const cl_device_id *device_list,
                                                          const char *kernel_names,
                                                          cl_int *errcode_ret,
                                                          cl_program returnValue);
angle::CallCapture CaptureCompileProgram(bool isCallValid,
                                         cl_program program,
                                         cl_uint num_devices,
                                         const cl_device_id *device_list,
                                         const char *options,
                                         cl_uint num_input_headers,
                                         const cl_program *input_headers,
                                         const char **header_include_names,
                                         void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                       void *user_data),
                                         void *user_data,
                                         cl_int returnValue);
angle::CallCapture CaptureLinkProgram(bool isCallValid,
                                      cl_context context,
                                      cl_uint num_devices,
                                      const cl_device_id *device_list,
                                      const char *options,
                                      cl_uint num_input_programs,
                                      const cl_program *input_programs,
                                      void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                    void *user_data),
                                      void *user_data,
                                      cl_int *errcode_ret,
                                      cl_program returnValue);
angle::CallCapture CaptureUnloadPlatformCompiler(bool isCallValid,
                                                 cl_platform_id platform,
                                                 cl_int returnValue);
angle::CallCapture CaptureGetKernelArgInfo(bool isCallValid,
                                           cl_kernel kernel,
                                           cl_uint arg_index,
                                           KernelArgInfo param_namePacked,
                                           size_t param_value_size,
                                           void *param_value,
                                           size_t *param_value_size_ret,
                                           cl_int returnValue);
angle::CallCapture CaptureEnqueueFillBuffer(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_mem buffer,
                                            const void *pattern,
                                            size_t pattern_size,
                                            size_t offset,
                                            size_t size,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int returnValue);
angle::CallCapture CaptureEnqueueFillImage(bool isCallValid,
                                           cl_command_queue command_queue,
                                           cl_mem image,
                                           const void *fill_color,
                                           const size_t *origin,
                                           const size_t *region,
                                           cl_uint num_events_in_wait_list,
                                           const cl_event *event_wait_list,
                                           cl_event *event,
                                           cl_int returnValue);
angle::CallCapture CaptureEnqueueMigrateMemObjects(bool isCallValid,
                                                   cl_command_queue command_queue,
                                                   cl_uint num_mem_objects,
                                                   const cl_mem *mem_objects,
                                                   MemMigrationFlags flagsPacked,
                                                   cl_uint num_events_in_wait_list,
                                                   const cl_event *event_wait_list,
                                                   cl_event *event,
                                                   cl_int returnValue);
angle::CallCapture CaptureEnqueueMarkerWithWaitList(bool isCallValid,
                                                    cl_command_queue command_queue,
                                                    cl_uint num_events_in_wait_list,
                                                    const cl_event *event_wait_list,
                                                    cl_event *event,
                                                    cl_int returnValue);
angle::CallCapture CaptureEnqueueBarrierWithWaitList(bool isCallValid,
                                                     cl_command_queue command_queue,
                                                     cl_uint num_events_in_wait_list,
                                                     const cl_event *event_wait_list,
                                                     cl_event *event,
                                                     cl_int returnValue);
angle::CallCapture CaptureGetExtensionFunctionAddressForPlatform(bool isCallValid,
                                                                 cl_platform_id platform,
                                                                 const char *func_name,
                                                                 void *returnValue);

// CL 2.0
angle::CallCapture CaptureCreateCommandQueueWithProperties(bool isCallValid,
                                                           cl_context context,
                                                           cl_device_id device,
                                                           const cl_queue_properties *properties,
                                                           cl_int *errcode_ret,
                                                           cl_command_queue returnValue);
angle::CallCapture CaptureCreatePipe(bool isCallValid,
                                     cl_context context,
                                     MemFlags flagsPacked,
                                     cl_uint pipe_packet_size,
                                     cl_uint pipe_max_packets,
                                     const cl_pipe_properties *properties,
                                     cl_int *errcode_ret,
                                     cl_mem returnValue);
angle::CallCapture CaptureGetPipeInfo(bool isCallValid,
                                      cl_mem pipe,
                                      PipeInfo param_namePacked,
                                      size_t param_value_size,
                                      void *param_value,
                                      size_t *param_value_size_ret,
                                      cl_int returnValue);
angle::CallCapture CaptureSVMAlloc(bool isCallValid,
                                   cl_context context,
                                   SVM_MemFlags flagsPacked,
                                   size_t size,
                                   cl_uint alignment,
                                   void *returnValue);
angle::CallCapture CaptureSVMFree(bool isCallValid, cl_context context, void *svm_pointer);
angle::CallCapture CaptureCreateSamplerWithProperties(
    bool isCallValid,
    cl_context context,
    const cl_sampler_properties *sampler_properties,
    cl_int *errcode_ret,
    cl_sampler returnValue);
angle::CallCapture CaptureSetKernelArgSVMPointer(bool isCallValid,
                                                 cl_kernel kernel,
                                                 cl_uint arg_index,
                                                 const void *arg_value,
                                                 cl_int returnValue);
angle::CallCapture CaptureSetKernelExecInfo(bool isCallValid,
                                            cl_kernel kernel,
                                            KernelExecInfo param_namePacked,
                                            size_t param_value_size,
                                            const void *param_value,
                                            cl_int returnValue);
angle::CallCapture CaptureEnqueueSVMFree(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_uint num_svm_pointers,
                                         void *svm_pointers[],
                                         void(CL_CALLBACK *pfn_free_func)(cl_command_queue queue,
                                                                          cl_uint num_svm_pointers,
                                                                          void *svm_pointers[],
                                                                          void *user_data),
                                         void *user_data,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         cl_int returnValue);
angle::CallCapture CaptureEnqueueSVMMemcpy(bool isCallValid,
                                           cl_command_queue command_queue,
                                           cl_bool blocking_copy,
                                           void *dst_ptr,
                                           const void *src_ptr,
                                           size_t size,
                                           cl_uint num_events_in_wait_list,
                                           const cl_event *event_wait_list,
                                           cl_event *event,
                                           cl_int returnValue);
angle::CallCapture CaptureEnqueueSVMMemFill(bool isCallValid,
                                            cl_command_queue command_queue,
                                            void *svm_ptr,
                                            const void *pattern,
                                            size_t pattern_size,
                                            size_t size,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int returnValue);
angle::CallCapture CaptureEnqueueSVMMap(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_bool blocking_map,
                                        MapFlags flagsPacked,
                                        void *svm_ptr,
                                        size_t size,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        cl_int returnValue);
angle::CallCapture CaptureEnqueueSVMUnmap(bool isCallValid,
                                          cl_command_queue command_queue,
                                          void *svm_ptr,
                                          cl_uint num_events_in_wait_list,
                                          const cl_event *event_wait_list,
                                          cl_event *event,
                                          cl_int returnValue);

// CL 2.1
angle::CallCapture CaptureSetDefaultDeviceCommandQueue(bool isCallValid,
                                                       cl_context context,
                                                       cl_device_id device,
                                                       cl_command_queue command_queue,
                                                       cl_int returnValue);
angle::CallCapture CaptureGetDeviceAndHostTimer(bool isCallValid,
                                                cl_device_id device,
                                                cl_ulong *device_timestamp,
                                                cl_ulong *host_timestamp,
                                                cl_int returnValue);
angle::CallCapture CaptureGetHostTimer(bool isCallValid,
                                       cl_device_id device,
                                       cl_ulong *host_timestamp,
                                       cl_int returnValue);
angle::CallCapture CaptureCreateProgramWithIL(bool isCallValid,
                                              cl_context context,
                                              const void *il,
                                              size_t length,
                                              cl_int *errcode_ret,
                                              cl_program returnValue);
angle::CallCapture CaptureCloneKernel(bool isCallValid,
                                      cl_kernel source_kernel,
                                      cl_int *errcode_ret,
                                      cl_kernel returnValue);
angle::CallCapture CaptureGetKernelSubGroupInfo(bool isCallValid,
                                                cl_kernel kernel,
                                                cl_device_id device,
                                                KernelSubGroupInfo param_namePacked,
                                                size_t input_value_size,
                                                const void *input_value,
                                                size_t param_value_size,
                                                void *param_value,
                                                size_t *param_value_size_ret,
                                                cl_int returnValue);
angle::CallCapture CaptureEnqueueSVMMigrateMem(bool isCallValid,
                                               cl_command_queue command_queue,
                                               cl_uint num_svm_pointers,
                                               const void **svm_pointers,
                                               const size_t *sizes,
                                               MemMigrationFlags flagsPacked,
                                               cl_uint num_events_in_wait_list,
                                               const cl_event *event_wait_list,
                                               cl_event *event,
                                               cl_int returnValue);

// CL 2.2
angle::CallCapture CaptureSetProgramReleaseCallback(
    bool isCallValid,
    cl_program program,
    void(CL_CALLBACK *pfn_notify)(cl_program program, void *user_data),
    void *user_data,
    cl_int returnValue);
angle::CallCapture CaptureSetProgramSpecializationConstant(bool isCallValid,
                                                           cl_program program,
                                                           cl_uint spec_id,
                                                           size_t spec_size,
                                                           const void *spec_value,
                                                           cl_int returnValue);

// CL 3.0
angle::CallCapture CaptureSetContextDestructorCallback(
    bool isCallValid,
    cl_context context,
    void(CL_CALLBACK *pfn_notify)(cl_context context, void *user_data),
    void *user_data,
    cl_int returnValue);
angle::CallCapture CaptureCreateBufferWithProperties(bool isCallValid,
                                                     cl_context context,
                                                     const cl_mem_properties *properties,
                                                     MemFlags flagsPacked,
                                                     size_t size,
                                                     void *host_ptr,
                                                     cl_int *errcode_ret,
                                                     cl_mem returnValue);
angle::CallCapture CaptureCreateImageWithProperties(bool isCallValid,
                                                    cl_context context,
                                                    const cl_mem_properties *properties,
                                                    MemFlags flagsPacked,
                                                    const cl_image_format *image_format,
                                                    const cl_image_desc *image_desc,
                                                    void *host_ptr,
                                                    cl_int *errcode_ret,
                                                    cl_mem returnValue);

// cl_khr_icd
angle::CallCapture CaptureIcdGetPlatformIDsKHR(bool isCallValid,
                                               cl_uint num_entries,
                                               cl_platform_id *platforms,
                                               cl_uint *num_platforms,
                                               cl_int returnValue);

// Parameter Captures

// CL 1.0
void CaptureGetPlatformIDs_platforms(bool isCallValid,
                                     cl_uint num_entries,
                                     cl_platform_id *platforms,
                                     cl_uint *num_platforms,
                                     angle::ParamCapture *paramCapture);
void CaptureGetPlatformIDs_num_platforms(bool isCallValid,
                                         cl_uint num_entries,
                                         cl_platform_id *platforms,
                                         cl_uint *num_platforms,
                                         angle::ParamCapture *paramCapture);
void CaptureGetPlatformInfo_param_value(bool isCallValid,
                                        cl_platform_id platform,
                                        PlatformInfo param_namePacked,
                                        size_t param_value_size,
                                        void *param_value,
                                        size_t *param_value_size_ret,
                                        angle::ParamCapture *paramCapture);
void CaptureGetPlatformInfo_param_value_size_ret(bool isCallValid,
                                                 cl_platform_id platform,
                                                 PlatformInfo param_namePacked,
                                                 size_t param_value_size,
                                                 void *param_value,
                                                 size_t *param_value_size_ret,
                                                 angle::ParamCapture *paramCapture);
void CaptureGetDeviceIDs_devices(bool isCallValid,
                                 cl_platform_id platform,
                                 DeviceType device_typePacked,
                                 cl_uint num_entries,
                                 cl_device_id *devices,
                                 cl_uint *num_devices,
                                 angle::ParamCapture *paramCapture);
void CaptureGetDeviceIDs_num_devices(bool isCallValid,
                                     cl_platform_id platform,
                                     DeviceType device_typePacked,
                                     cl_uint num_entries,
                                     cl_device_id *devices,
                                     cl_uint *num_devices,
                                     angle::ParamCapture *paramCapture);
void CaptureGetDeviceInfo_param_value(bool isCallValid,
                                      cl_device_id device,
                                      DeviceInfo param_namePacked,
                                      size_t param_value_size,
                                      void *param_value,
                                      size_t *param_value_size_ret,
                                      angle::ParamCapture *paramCapture);
void CaptureGetDeviceInfo_param_value_size_ret(bool isCallValid,
                                               cl_device_id device,
                                               DeviceInfo param_namePacked,
                                               size_t param_value_size,
                                               void *param_value,
                                               size_t *param_value_size_ret,
                                               angle::ParamCapture *paramCapture);
void CaptureCreateContext_properties(bool isCallValid,
                                     const cl_context_properties *properties,
                                     cl_uint num_devices,
                                     const cl_device_id *devices,
                                     void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                                   const void *private_info,
                                                                   size_t cb,
                                                                   void *user_data),
                                     void *user_data,
                                     cl_int *errcode_ret,
                                     angle::ParamCapture *paramCapture);
void CaptureCreateContext_devices(bool isCallValid,
                                  const cl_context_properties *properties,
                                  cl_uint num_devices,
                                  const cl_device_id *devices,
                                  void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                                const void *private_info,
                                                                size_t cb,
                                                                void *user_data),
                                  void *user_data,
                                  cl_int *errcode_ret,
                                  angle::ParamCapture *paramCapture);
void CaptureCreateContext_pfn_notify(bool isCallValid,
                                     const cl_context_properties *properties,
                                     cl_uint num_devices,
                                     const cl_device_id *devices,
                                     void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                                   const void *private_info,
                                                                   size_t cb,
                                                                   void *user_data),
                                     void *user_data,
                                     cl_int *errcode_ret,
                                     angle::ParamCapture *paramCapture);
void CaptureCreateContext_user_data(bool isCallValid,
                                    const cl_context_properties *properties,
                                    cl_uint num_devices,
                                    const cl_device_id *devices,
                                    void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                                  const void *private_info,
                                                                  size_t cb,
                                                                  void *user_data),
                                    void *user_data,
                                    cl_int *errcode_ret,
                                    angle::ParamCapture *paramCapture);
void CaptureCreateContext_errcode_ret(bool isCallValid,
                                      const cl_context_properties *properties,
                                      cl_uint num_devices,
                                      const cl_device_id *devices,
                                      void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                                    const void *private_info,
                                                                    size_t cb,
                                                                    void *user_data),
                                      void *user_data,
                                      cl_int *errcode_ret,
                                      angle::ParamCapture *paramCapture);
void CaptureCreateContextFromType_properties(bool isCallValid,
                                             const cl_context_properties *properties,
                                             DeviceType device_typePacked,
                                             void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                                           const void *private_info,
                                                                           size_t cb,
                                                                           void *user_data),
                                             void *user_data,
                                             cl_int *errcode_ret,
                                             angle::ParamCapture *paramCapture);
void CaptureCreateContextFromType_pfn_notify(bool isCallValid,
                                             const cl_context_properties *properties,
                                             DeviceType device_typePacked,
                                             void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                                           const void *private_info,
                                                                           size_t cb,
                                                                           void *user_data),
                                             void *user_data,
                                             cl_int *errcode_ret,
                                             angle::ParamCapture *paramCapture);
void CaptureCreateContextFromType_user_data(bool isCallValid,
                                            const cl_context_properties *properties,
                                            DeviceType device_typePacked,
                                            void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                                                          const void *private_info,
                                                                          size_t cb,
                                                                          void *user_data),
                                            void *user_data,
                                            cl_int *errcode_ret,
                                            angle::ParamCapture *paramCapture);
void CaptureCreateContextFromType_errcode_ret(
    bool isCallValid,
    const cl_context_properties *properties,
    DeviceType device_typePacked,
    void(CL_CALLBACK *pfn_notify)(const char *errinfo,
                                  const void *private_info,
                                  size_t cb,
                                  void *user_data),
    void *user_data,
    cl_int *errcode_ret,
    angle::ParamCapture *paramCapture);
void CaptureGetContextInfo_param_value(bool isCallValid,
                                       cl_context context,
                                       ContextInfo param_namePacked,
                                       size_t param_value_size,
                                       void *param_value,
                                       size_t *param_value_size_ret,
                                       angle::ParamCapture *paramCapture);
void CaptureGetContextInfo_param_value_size_ret(bool isCallValid,
                                                cl_context context,
                                                ContextInfo param_namePacked,
                                                size_t param_value_size,
                                                void *param_value,
                                                size_t *param_value_size_ret,
                                                angle::ParamCapture *paramCapture);
void CaptureGetCommandQueueInfo_param_value(bool isCallValid,
                                            cl_command_queue command_queue,
                                            CommandQueueInfo param_namePacked,
                                            size_t param_value_size,
                                            void *param_value,
                                            size_t *param_value_size_ret,
                                            angle::ParamCapture *paramCapture);
void CaptureGetCommandQueueInfo_param_value_size_ret(bool isCallValid,
                                                     cl_command_queue command_queue,
                                                     CommandQueueInfo param_namePacked,
                                                     size_t param_value_size,
                                                     void *param_value,
                                                     size_t *param_value_size_ret,
                                                     angle::ParamCapture *paramCapture);
void CaptureCreateBuffer_host_ptr(bool isCallValid,
                                  cl_context context,
                                  MemFlags flagsPacked,
                                  size_t size,
                                  void *host_ptr,
                                  cl_int *errcode_ret,
                                  angle::ParamCapture *paramCapture);
void CaptureCreateBuffer_errcode_ret(bool isCallValid,
                                     cl_context context,
                                     MemFlags flagsPacked,
                                     size_t size,
                                     void *host_ptr,
                                     cl_int *errcode_ret,
                                     angle::ParamCapture *paramCapture);
void CaptureGetSupportedImageFormats_image_formats(bool isCallValid,
                                                   cl_context context,
                                                   MemFlags flagsPacked,
                                                   MemObjectType image_typePacked,
                                                   cl_uint num_entries,
                                                   cl_image_format *image_formats,
                                                   cl_uint *num_image_formats,
                                                   angle::ParamCapture *paramCapture);
void CaptureGetSupportedImageFormats_num_image_formats(bool isCallValid,
                                                       cl_context context,
                                                       MemFlags flagsPacked,
                                                       MemObjectType image_typePacked,
                                                       cl_uint num_entries,
                                                       cl_image_format *image_formats,
                                                       cl_uint *num_image_formats,
                                                       angle::ParamCapture *paramCapture);
void CaptureGetMemObjectInfo_param_value(bool isCallValid,
                                         cl_mem memobj,
                                         MemInfo param_namePacked,
                                         size_t param_value_size,
                                         void *param_value,
                                         size_t *param_value_size_ret,
                                         angle::ParamCapture *paramCapture);
void CaptureGetMemObjectInfo_param_value_size_ret(bool isCallValid,
                                                  cl_mem memobj,
                                                  MemInfo param_namePacked,
                                                  size_t param_value_size,
                                                  void *param_value,
                                                  size_t *param_value_size_ret,
                                                  angle::ParamCapture *paramCapture);
void CaptureGetImageInfo_param_value(bool isCallValid,
                                     cl_mem image,
                                     ImageInfo param_namePacked,
                                     size_t param_value_size,
                                     void *param_value,
                                     size_t *param_value_size_ret,
                                     angle::ParamCapture *paramCapture);
void CaptureGetImageInfo_param_value_size_ret(bool isCallValid,
                                              cl_mem image,
                                              ImageInfo param_namePacked,
                                              size_t param_value_size,
                                              void *param_value,
                                              size_t *param_value_size_ret,
                                              angle::ParamCapture *paramCapture);
void CaptureGetSamplerInfo_param_value(bool isCallValid,
                                       cl_sampler sampler,
                                       SamplerInfo param_namePacked,
                                       size_t param_value_size,
                                       void *param_value,
                                       size_t *param_value_size_ret,
                                       angle::ParamCapture *paramCapture);
void CaptureGetSamplerInfo_param_value_size_ret(bool isCallValid,
                                                cl_sampler sampler,
                                                SamplerInfo param_namePacked,
                                                size_t param_value_size,
                                                void *param_value,
                                                size_t *param_value_size_ret,
                                                angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithSource_strings(bool isCallValid,
                                            cl_context context,
                                            cl_uint count,
                                            const char **strings,
                                            const size_t *lengths,
                                            cl_int *errcode_ret,
                                            angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithSource_lengths(bool isCallValid,
                                            cl_context context,
                                            cl_uint count,
                                            const char **strings,
                                            const size_t *lengths,
                                            cl_int *errcode_ret,
                                            angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithSource_errcode_ret(bool isCallValid,
                                                cl_context context,
                                                cl_uint count,
                                                const char **strings,
                                                const size_t *lengths,
                                                cl_int *errcode_ret,
                                                angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithBinary_device_list(bool isCallValid,
                                                cl_context context,
                                                cl_uint num_devices,
                                                const cl_device_id *device_list,
                                                const size_t *lengths,
                                                const unsigned char **binaries,
                                                cl_int *binary_status,
                                                cl_int *errcode_ret,
                                                angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithBinary_lengths(bool isCallValid,
                                            cl_context context,
                                            cl_uint num_devices,
                                            const cl_device_id *device_list,
                                            const size_t *lengths,
                                            const unsigned char **binaries,
                                            cl_int *binary_status,
                                            cl_int *errcode_ret,
                                            angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithBinary_binaries(bool isCallValid,
                                             cl_context context,
                                             cl_uint num_devices,
                                             const cl_device_id *device_list,
                                             const size_t *lengths,
                                             const unsigned char **binaries,
                                             cl_int *binary_status,
                                             cl_int *errcode_ret,
                                             angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithBinary_binary_status(bool isCallValid,
                                                  cl_context context,
                                                  cl_uint num_devices,
                                                  const cl_device_id *device_list,
                                                  const size_t *lengths,
                                                  const unsigned char **binaries,
                                                  cl_int *binary_status,
                                                  cl_int *errcode_ret,
                                                  angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithBinary_errcode_ret(bool isCallValid,
                                                cl_context context,
                                                cl_uint num_devices,
                                                const cl_device_id *device_list,
                                                const size_t *lengths,
                                                const unsigned char **binaries,
                                                cl_int *binary_status,
                                                cl_int *errcode_ret,
                                                angle::ParamCapture *paramCapture);
void CaptureBuildProgram_device_list(bool isCallValid,
                                     cl_program program,
                                     cl_uint num_devices,
                                     const cl_device_id *device_list,
                                     const char *options,
                                     void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                   void *user_data),
                                     void *user_data,
                                     angle::ParamCapture *paramCapture);
void CaptureBuildProgram_options(bool isCallValid,
                                 cl_program program,
                                 cl_uint num_devices,
                                 const cl_device_id *device_list,
                                 const char *options,
                                 void(CL_CALLBACK *pfn_notify)(cl_program program, void *user_data),
                                 void *user_data,
                                 angle::ParamCapture *paramCapture);
void CaptureBuildProgram_pfn_notify(bool isCallValid,
                                    cl_program program,
                                    cl_uint num_devices,
                                    const cl_device_id *device_list,
                                    const char *options,
                                    void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                  void *user_data),
                                    void *user_data,
                                    angle::ParamCapture *paramCapture);
void CaptureBuildProgram_user_data(bool isCallValid,
                                   cl_program program,
                                   cl_uint num_devices,
                                   const cl_device_id *device_list,
                                   const char *options,
                                   void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                 void *user_data),
                                   void *user_data,
                                   angle::ParamCapture *paramCapture);
void CaptureGetProgramInfo_param_value(bool isCallValid,
                                       cl_program program,
                                       ProgramInfo param_namePacked,
                                       size_t param_value_size,
                                       void *param_value,
                                       size_t *param_value_size_ret,
                                       angle::ParamCapture *paramCapture);
void CaptureGetProgramInfo_param_value_size_ret(bool isCallValid,
                                                cl_program program,
                                                ProgramInfo param_namePacked,
                                                size_t param_value_size,
                                                void *param_value,
                                                size_t *param_value_size_ret,
                                                angle::ParamCapture *paramCapture);
void CaptureGetProgramBuildInfo_param_value(bool isCallValid,
                                            cl_program program,
                                            cl_device_id device,
                                            ProgramBuildInfo param_namePacked,
                                            size_t param_value_size,
                                            void *param_value,
                                            size_t *param_value_size_ret,
                                            angle::ParamCapture *paramCapture);
void CaptureGetProgramBuildInfo_param_value_size_ret(bool isCallValid,
                                                     cl_program program,
                                                     cl_device_id device,
                                                     ProgramBuildInfo param_namePacked,
                                                     size_t param_value_size,
                                                     void *param_value,
                                                     size_t *param_value_size_ret,
                                                     angle::ParamCapture *paramCapture);
void CaptureCreateKernel_kernel_name(bool isCallValid,
                                     cl_program program,
                                     const char *kernel_name,
                                     cl_int *errcode_ret,
                                     angle::ParamCapture *paramCapture);
void CaptureCreateKernel_errcode_ret(bool isCallValid,
                                     cl_program program,
                                     const char *kernel_name,
                                     cl_int *errcode_ret,
                                     angle::ParamCapture *paramCapture);
void CaptureCreateKernelsInProgram_kernels(bool isCallValid,
                                           cl_program program,
                                           cl_uint num_kernels,
                                           cl_kernel *kernels,
                                           cl_uint *num_kernels_ret,
                                           angle::ParamCapture *paramCapture);
void CaptureCreateKernelsInProgram_num_kernels_ret(bool isCallValid,
                                                   cl_program program,
                                                   cl_uint num_kernels,
                                                   cl_kernel *kernels,
                                                   cl_uint *num_kernels_ret,
                                                   angle::ParamCapture *paramCapture);
void CaptureSetKernelArg_arg_value(bool isCallValid,
                                   cl_kernel kernel,
                                   cl_uint arg_index,
                                   size_t arg_size,
                                   const void *arg_value,
                                   angle::ParamCapture *paramCapture);
void CaptureGetKernelInfo_param_value(bool isCallValid,
                                      cl_kernel kernel,
                                      KernelInfo param_namePacked,
                                      size_t param_value_size,
                                      void *param_value,
                                      size_t *param_value_size_ret,
                                      angle::ParamCapture *paramCapture);
void CaptureGetKernelInfo_param_value_size_ret(bool isCallValid,
                                               cl_kernel kernel,
                                               KernelInfo param_namePacked,
                                               size_t param_value_size,
                                               void *param_value,
                                               size_t *param_value_size_ret,
                                               angle::ParamCapture *paramCapture);
void CaptureGetKernelWorkGroupInfo_param_value(bool isCallValid,
                                               cl_kernel kernel,
                                               cl_device_id device,
                                               KernelWorkGroupInfo param_namePacked,
                                               size_t param_value_size,
                                               void *param_value,
                                               size_t *param_value_size_ret,
                                               angle::ParamCapture *paramCapture);
void CaptureGetKernelWorkGroupInfo_param_value_size_ret(bool isCallValid,
                                                        cl_kernel kernel,
                                                        cl_device_id device,
                                                        KernelWorkGroupInfo param_namePacked,
                                                        size_t param_value_size,
                                                        void *param_value,
                                                        size_t *param_value_size_ret,
                                                        angle::ParamCapture *paramCapture);
void CaptureWaitForEvents_event_list(bool isCallValid,
                                     cl_uint num_events,
                                     const cl_event *event_list,
                                     angle::ParamCapture *paramCapture);
void CaptureGetEventInfo_param_value(bool isCallValid,
                                     cl_event event,
                                     EventInfo param_namePacked,
                                     size_t param_value_size,
                                     void *param_value,
                                     size_t *param_value_size_ret,
                                     angle::ParamCapture *paramCapture);
void CaptureGetEventInfo_param_value_size_ret(bool isCallValid,
                                              cl_event event,
                                              EventInfo param_namePacked,
                                              size_t param_value_size,
                                              void *param_value,
                                              size_t *param_value_size_ret,
                                              angle::ParamCapture *paramCapture);
void CaptureGetEventProfilingInfo_param_value(bool isCallValid,
                                              cl_event event,
                                              ProfilingInfo param_namePacked,
                                              size_t param_value_size,
                                              void *param_value,
                                              size_t *param_value_size_ret,
                                              angle::ParamCapture *paramCapture);
void CaptureGetEventProfilingInfo_param_value_size_ret(bool isCallValid,
                                                       cl_event event,
                                                       ProfilingInfo param_namePacked,
                                                       size_t param_value_size,
                                                       void *param_value,
                                                       size_t *param_value_size_ret,
                                                       angle::ParamCapture *paramCapture);
void CaptureEnqueueReadBuffer_ptr(bool isCallValid,
                                  cl_command_queue command_queue,
                                  cl_mem buffer,
                                  cl_bool blocking_read,
                                  size_t offset,
                                  size_t size,
                                  void *ptr,
                                  cl_uint num_events_in_wait_list,
                                  const cl_event *event_wait_list,
                                  cl_event *event,
                                  angle::ParamCapture *paramCapture);
void CaptureEnqueueReadBuffer_event_wait_list(bool isCallValid,
                                              cl_command_queue command_queue,
                                              cl_mem buffer,
                                              cl_bool blocking_read,
                                              size_t offset,
                                              size_t size,
                                              void *ptr,
                                              cl_uint num_events_in_wait_list,
                                              const cl_event *event_wait_list,
                                              cl_event *event,
                                              angle::ParamCapture *paramCapture);
void CaptureEnqueueReadBuffer_event(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem buffer,
                                    cl_bool blocking_read,
                                    size_t offset,
                                    size_t size,
                                    void *ptr,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteBuffer_ptr(bool isCallValid,
                                   cl_command_queue command_queue,
                                   cl_mem buffer,
                                   cl_bool blocking_write,
                                   size_t offset,
                                   size_t size,
                                   const void *ptr,
                                   cl_uint num_events_in_wait_list,
                                   const cl_event *event_wait_list,
                                   cl_event *event,
                                   angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteBuffer_event_wait_list(bool isCallValid,
                                               cl_command_queue command_queue,
                                               cl_mem buffer,
                                               cl_bool blocking_write,
                                               size_t offset,
                                               size_t size,
                                               const void *ptr,
                                               cl_uint num_events_in_wait_list,
                                               const cl_event *event_wait_list,
                                               cl_event *event,
                                               angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteBuffer_event(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_mem buffer,
                                     cl_bool blocking_write,
                                     size_t offset,
                                     size_t size,
                                     const void *ptr,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyBuffer_event_wait_list(bool isCallValid,
                                              cl_command_queue command_queue,
                                              cl_mem src_buffer,
                                              cl_mem dst_buffer,
                                              size_t src_offset,
                                              size_t dst_offset,
                                              size_t size,
                                              cl_uint num_events_in_wait_list,
                                              const cl_event *event_wait_list,
                                              cl_event *event,
                                              angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyBuffer_event(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem src_buffer,
                                    cl_mem dst_buffer,
                                    size_t src_offset,
                                    size_t dst_offset,
                                    size_t size,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    angle::ParamCapture *paramCapture);
void CaptureEnqueueReadImage_origin(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem image,
                                    cl_bool blocking_read,
                                    const size_t *origin,
                                    const size_t *region,
                                    size_t row_pitch,
                                    size_t slice_pitch,
                                    void *ptr,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    angle::ParamCapture *paramCapture);
void CaptureEnqueueReadImage_region(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem image,
                                    cl_bool blocking_read,
                                    const size_t *origin,
                                    const size_t *region,
                                    size_t row_pitch,
                                    size_t slice_pitch,
                                    void *ptr,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    angle::ParamCapture *paramCapture);
void CaptureEnqueueReadImage_ptr(bool isCallValid,
                                 cl_command_queue command_queue,
                                 cl_mem image,
                                 cl_bool blocking_read,
                                 const size_t *origin,
                                 const size_t *region,
                                 size_t row_pitch,
                                 size_t slice_pitch,
                                 void *ptr,
                                 cl_uint num_events_in_wait_list,
                                 const cl_event *event_wait_list,
                                 cl_event *event,
                                 angle::ParamCapture *paramCapture);
void CaptureEnqueueReadImage_event_wait_list(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_mem image,
                                             cl_bool blocking_read,
                                             const size_t *origin,
                                             const size_t *region,
                                             size_t row_pitch,
                                             size_t slice_pitch,
                                             void *ptr,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             angle::ParamCapture *paramCapture);
void CaptureEnqueueReadImage_event(bool isCallValid,
                                   cl_command_queue command_queue,
                                   cl_mem image,
                                   cl_bool blocking_read,
                                   const size_t *origin,
                                   const size_t *region,
                                   size_t row_pitch,
                                   size_t slice_pitch,
                                   void *ptr,
                                   cl_uint num_events_in_wait_list,
                                   const cl_event *event_wait_list,
                                   cl_event *event,
                                   angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteImage_origin(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_mem image,
                                     cl_bool blocking_write,
                                     const size_t *origin,
                                     const size_t *region,
                                     size_t input_row_pitch,
                                     size_t input_slice_pitch,
                                     const void *ptr,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteImage_region(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_mem image,
                                     cl_bool blocking_write,
                                     const size_t *origin,
                                     const size_t *region,
                                     size_t input_row_pitch,
                                     size_t input_slice_pitch,
                                     const void *ptr,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteImage_ptr(bool isCallValid,
                                  cl_command_queue command_queue,
                                  cl_mem image,
                                  cl_bool blocking_write,
                                  const size_t *origin,
                                  const size_t *region,
                                  size_t input_row_pitch,
                                  size_t input_slice_pitch,
                                  const void *ptr,
                                  cl_uint num_events_in_wait_list,
                                  const cl_event *event_wait_list,
                                  cl_event *event,
                                  angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteImage_event_wait_list(bool isCallValid,
                                              cl_command_queue command_queue,
                                              cl_mem image,
                                              cl_bool blocking_write,
                                              const size_t *origin,
                                              const size_t *region,
                                              size_t input_row_pitch,
                                              size_t input_slice_pitch,
                                              const void *ptr,
                                              cl_uint num_events_in_wait_list,
                                              const cl_event *event_wait_list,
                                              cl_event *event,
                                              angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteImage_event(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem image,
                                    cl_bool blocking_write,
                                    const size_t *origin,
                                    const size_t *region,
                                    size_t input_row_pitch,
                                    size_t input_slice_pitch,
                                    const void *ptr,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyImage_src_origin(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_mem src_image,
                                        cl_mem dst_image,
                                        const size_t *src_origin,
                                        const size_t *dst_origin,
                                        const size_t *region,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyImage_dst_origin(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_mem src_image,
                                        cl_mem dst_image,
                                        const size_t *src_origin,
                                        const size_t *dst_origin,
                                        const size_t *region,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyImage_region(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem src_image,
                                    cl_mem dst_image,
                                    const size_t *src_origin,
                                    const size_t *dst_origin,
                                    const size_t *region,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyImage_event_wait_list(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_mem src_image,
                                             cl_mem dst_image,
                                             const size_t *src_origin,
                                             const size_t *dst_origin,
                                             const size_t *region,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyImage_event(bool isCallValid,
                                   cl_command_queue command_queue,
                                   cl_mem src_image,
                                   cl_mem dst_image,
                                   const size_t *src_origin,
                                   const size_t *dst_origin,
                                   const size_t *region,
                                   cl_uint num_events_in_wait_list,
                                   const cl_event *event_wait_list,
                                   cl_event *event,
                                   angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyImageToBuffer_src_origin(bool isCallValid,
                                                cl_command_queue command_queue,
                                                cl_mem src_image,
                                                cl_mem dst_buffer,
                                                const size_t *src_origin,
                                                const size_t *region,
                                                size_t dst_offset,
                                                cl_uint num_events_in_wait_list,
                                                const cl_event *event_wait_list,
                                                cl_event *event,
                                                angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyImageToBuffer_region(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_mem src_image,
                                            cl_mem dst_buffer,
                                            const size_t *src_origin,
                                            const size_t *region,
                                            size_t dst_offset,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyImageToBuffer_event_wait_list(bool isCallValid,
                                                     cl_command_queue command_queue,
                                                     cl_mem src_image,
                                                     cl_mem dst_buffer,
                                                     const size_t *src_origin,
                                                     const size_t *region,
                                                     size_t dst_offset,
                                                     cl_uint num_events_in_wait_list,
                                                     const cl_event *event_wait_list,
                                                     cl_event *event,
                                                     angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyImageToBuffer_event(bool isCallValid,
                                           cl_command_queue command_queue,
                                           cl_mem src_image,
                                           cl_mem dst_buffer,
                                           const size_t *src_origin,
                                           const size_t *region,
                                           size_t dst_offset,
                                           cl_uint num_events_in_wait_list,
                                           const cl_event *event_wait_list,
                                           cl_event *event,
                                           angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyBufferToImage_dst_origin(bool isCallValid,
                                                cl_command_queue command_queue,
                                                cl_mem src_buffer,
                                                cl_mem dst_image,
                                                size_t src_offset,
                                                const size_t *dst_origin,
                                                const size_t *region,
                                                cl_uint num_events_in_wait_list,
                                                const cl_event *event_wait_list,
                                                cl_event *event,
                                                angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyBufferToImage_region(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_mem src_buffer,
                                            cl_mem dst_image,
                                            size_t src_offset,
                                            const size_t *dst_origin,
                                            const size_t *region,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyBufferToImage_event_wait_list(bool isCallValid,
                                                     cl_command_queue command_queue,
                                                     cl_mem src_buffer,
                                                     cl_mem dst_image,
                                                     size_t src_offset,
                                                     const size_t *dst_origin,
                                                     const size_t *region,
                                                     cl_uint num_events_in_wait_list,
                                                     const cl_event *event_wait_list,
                                                     cl_event *event,
                                                     angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyBufferToImage_event(bool isCallValid,
                                           cl_command_queue command_queue,
                                           cl_mem src_buffer,
                                           cl_mem dst_image,
                                           size_t src_offset,
                                           const size_t *dst_origin,
                                           const size_t *region,
                                           cl_uint num_events_in_wait_list,
                                           const cl_event *event_wait_list,
                                           cl_event *event,
                                           angle::ParamCapture *paramCapture);
void CaptureEnqueueMapBuffer_event_wait_list(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_mem buffer,
                                             cl_bool blocking_map,
                                             MapFlags map_flagsPacked,
                                             size_t offset,
                                             size_t size,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             cl_int *errcode_ret,
                                             angle::ParamCapture *paramCapture);
void CaptureEnqueueMapBuffer_event(bool isCallValid,
                                   cl_command_queue command_queue,
                                   cl_mem buffer,
                                   cl_bool blocking_map,
                                   MapFlags map_flagsPacked,
                                   size_t offset,
                                   size_t size,
                                   cl_uint num_events_in_wait_list,
                                   const cl_event *event_wait_list,
                                   cl_event *event,
                                   cl_int *errcode_ret,
                                   angle::ParamCapture *paramCapture);
void CaptureEnqueueMapBuffer_errcode_ret(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_mem buffer,
                                         cl_bool blocking_map,
                                         MapFlags map_flagsPacked,
                                         size_t offset,
                                         size_t size,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         cl_int *errcode_ret,
                                         angle::ParamCapture *paramCapture);
void CaptureEnqueueMapImage_origin(bool isCallValid,
                                   cl_command_queue command_queue,
                                   cl_mem image,
                                   cl_bool blocking_map,
                                   MapFlags map_flagsPacked,
                                   const size_t *origin,
                                   const size_t *region,
                                   size_t *image_row_pitch,
                                   size_t *image_slice_pitch,
                                   cl_uint num_events_in_wait_list,
                                   const cl_event *event_wait_list,
                                   cl_event *event,
                                   cl_int *errcode_ret,
                                   angle::ParamCapture *paramCapture);
void CaptureEnqueueMapImage_region(bool isCallValid,
                                   cl_command_queue command_queue,
                                   cl_mem image,
                                   cl_bool blocking_map,
                                   MapFlags map_flagsPacked,
                                   const size_t *origin,
                                   const size_t *region,
                                   size_t *image_row_pitch,
                                   size_t *image_slice_pitch,
                                   cl_uint num_events_in_wait_list,
                                   const cl_event *event_wait_list,
                                   cl_event *event,
                                   cl_int *errcode_ret,
                                   angle::ParamCapture *paramCapture);
void CaptureEnqueueMapImage_image_row_pitch(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_mem image,
                                            cl_bool blocking_map,
                                            MapFlags map_flagsPacked,
                                            const size_t *origin,
                                            const size_t *region,
                                            size_t *image_row_pitch,
                                            size_t *image_slice_pitch,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int *errcode_ret,
                                            angle::ParamCapture *paramCapture);
void CaptureEnqueueMapImage_image_slice_pitch(bool isCallValid,
                                              cl_command_queue command_queue,
                                              cl_mem image,
                                              cl_bool blocking_map,
                                              MapFlags map_flagsPacked,
                                              const size_t *origin,
                                              const size_t *region,
                                              size_t *image_row_pitch,
                                              size_t *image_slice_pitch,
                                              cl_uint num_events_in_wait_list,
                                              const cl_event *event_wait_list,
                                              cl_event *event,
                                              cl_int *errcode_ret,
                                              angle::ParamCapture *paramCapture);
void CaptureEnqueueMapImage_event_wait_list(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_mem image,
                                            cl_bool blocking_map,
                                            MapFlags map_flagsPacked,
                                            const size_t *origin,
                                            const size_t *region,
                                            size_t *image_row_pitch,
                                            size_t *image_slice_pitch,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            cl_int *errcode_ret,
                                            angle::ParamCapture *paramCapture);
void CaptureEnqueueMapImage_event(bool isCallValid,
                                  cl_command_queue command_queue,
                                  cl_mem image,
                                  cl_bool blocking_map,
                                  MapFlags map_flagsPacked,
                                  const size_t *origin,
                                  const size_t *region,
                                  size_t *image_row_pitch,
                                  size_t *image_slice_pitch,
                                  cl_uint num_events_in_wait_list,
                                  const cl_event *event_wait_list,
                                  cl_event *event,
                                  cl_int *errcode_ret,
                                  angle::ParamCapture *paramCapture);
void CaptureEnqueueMapImage_errcode_ret(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_mem image,
                                        cl_bool blocking_map,
                                        MapFlags map_flagsPacked,
                                        const size_t *origin,
                                        const size_t *region,
                                        size_t *image_row_pitch,
                                        size_t *image_slice_pitch,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        cl_int *errcode_ret,
                                        angle::ParamCapture *paramCapture);
void CaptureEnqueueUnmapMemObject_mapped_ptr(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_mem memobj,
                                             void *mapped_ptr,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             angle::ParamCapture *paramCapture);
void CaptureEnqueueUnmapMemObject_event_wait_list(bool isCallValid,
                                                  cl_command_queue command_queue,
                                                  cl_mem memobj,
                                                  void *mapped_ptr,
                                                  cl_uint num_events_in_wait_list,
                                                  const cl_event *event_wait_list,
                                                  cl_event *event,
                                                  angle::ParamCapture *paramCapture);
void CaptureEnqueueUnmapMemObject_event(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_mem memobj,
                                        void *mapped_ptr,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        angle::ParamCapture *paramCapture);
void CaptureEnqueueNDRangeKernel_global_work_offset(bool isCallValid,
                                                    cl_command_queue command_queue,
                                                    cl_kernel kernel,
                                                    cl_uint work_dim,
                                                    const size_t *global_work_offset,
                                                    const size_t *global_work_size,
                                                    const size_t *local_work_size,
                                                    cl_uint num_events_in_wait_list,
                                                    const cl_event *event_wait_list,
                                                    cl_event *event,
                                                    angle::ParamCapture *paramCapture);
void CaptureEnqueueNDRangeKernel_global_work_size(bool isCallValid,
                                                  cl_command_queue command_queue,
                                                  cl_kernel kernel,
                                                  cl_uint work_dim,
                                                  const size_t *global_work_offset,
                                                  const size_t *global_work_size,
                                                  const size_t *local_work_size,
                                                  cl_uint num_events_in_wait_list,
                                                  const cl_event *event_wait_list,
                                                  cl_event *event,
                                                  angle::ParamCapture *paramCapture);
void CaptureEnqueueNDRangeKernel_local_work_size(bool isCallValid,
                                                 cl_command_queue command_queue,
                                                 cl_kernel kernel,
                                                 cl_uint work_dim,
                                                 const size_t *global_work_offset,
                                                 const size_t *global_work_size,
                                                 const size_t *local_work_size,
                                                 cl_uint num_events_in_wait_list,
                                                 const cl_event *event_wait_list,
                                                 cl_event *event,
                                                 angle::ParamCapture *paramCapture);
void CaptureEnqueueNDRangeKernel_event_wait_list(bool isCallValid,
                                                 cl_command_queue command_queue,
                                                 cl_kernel kernel,
                                                 cl_uint work_dim,
                                                 const size_t *global_work_offset,
                                                 const size_t *global_work_size,
                                                 const size_t *local_work_size,
                                                 cl_uint num_events_in_wait_list,
                                                 const cl_event *event_wait_list,
                                                 cl_event *event,
                                                 angle::ParamCapture *paramCapture);
void CaptureEnqueueNDRangeKernel_event(bool isCallValid,
                                       cl_command_queue command_queue,
                                       cl_kernel kernel,
                                       cl_uint work_dim,
                                       const size_t *global_work_offset,
                                       const size_t *global_work_size,
                                       const size_t *local_work_size,
                                       cl_uint num_events_in_wait_list,
                                       const cl_event *event_wait_list,
                                       cl_event *event,
                                       angle::ParamCapture *paramCapture);
void CaptureEnqueueNativeKernel_user_func(bool isCallValid,
                                          cl_command_queue command_queue,
                                          void(CL_CALLBACK *user_func)(void *),
                                          void *args,
                                          size_t cb_args,
                                          cl_uint num_mem_objects,
                                          const cl_mem *mem_list,
                                          const void **args_mem_loc,
                                          cl_uint num_events_in_wait_list,
                                          const cl_event *event_wait_list,
                                          cl_event *event,
                                          angle::ParamCapture *paramCapture);
void CaptureEnqueueNativeKernel_args(bool isCallValid,
                                     cl_command_queue command_queue,
                                     void(CL_CALLBACK *user_func)(void *),
                                     void *args,
                                     size_t cb_args,
                                     cl_uint num_mem_objects,
                                     const cl_mem *mem_list,
                                     const void **args_mem_loc,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     angle::ParamCapture *paramCapture);
void CaptureEnqueueNativeKernel_mem_list(bool isCallValid,
                                         cl_command_queue command_queue,
                                         void(CL_CALLBACK *user_func)(void *),
                                         void *args,
                                         size_t cb_args,
                                         cl_uint num_mem_objects,
                                         const cl_mem *mem_list,
                                         const void **args_mem_loc,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         angle::ParamCapture *paramCapture);
void CaptureEnqueueNativeKernel_args_mem_loc(bool isCallValid,
                                             cl_command_queue command_queue,
                                             void(CL_CALLBACK *user_func)(void *),
                                             void *args,
                                             size_t cb_args,
                                             cl_uint num_mem_objects,
                                             const cl_mem *mem_list,
                                             const void **args_mem_loc,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             angle::ParamCapture *paramCapture);
void CaptureEnqueueNativeKernel_event_wait_list(bool isCallValid,
                                                cl_command_queue command_queue,
                                                void(CL_CALLBACK *user_func)(void *),
                                                void *args,
                                                size_t cb_args,
                                                cl_uint num_mem_objects,
                                                const cl_mem *mem_list,
                                                const void **args_mem_loc,
                                                cl_uint num_events_in_wait_list,
                                                const cl_event *event_wait_list,
                                                cl_event *event,
                                                angle::ParamCapture *paramCapture);
void CaptureEnqueueNativeKernel_event(bool isCallValid,
                                      cl_command_queue command_queue,
                                      void(CL_CALLBACK *user_func)(void *),
                                      void *args,
                                      size_t cb_args,
                                      cl_uint num_mem_objects,
                                      const cl_mem *mem_list,
                                      const void **args_mem_loc,
                                      cl_uint num_events_in_wait_list,
                                      const cl_event *event_wait_list,
                                      cl_event *event,
                                      angle::ParamCapture *paramCapture);
void CaptureSetCommandQueueProperty_old_properties(bool isCallValid,
                                                   cl_command_queue command_queue,
                                                   CommandQueueProperties propertiesPacked,
                                                   cl_bool enable,
                                                   cl_command_queue_properties *old_properties,
                                                   angle::ParamCapture *paramCapture);
void CaptureCreateImage2D_image_format(bool isCallValid,
                                       cl_context context,
                                       MemFlags flagsPacked,
                                       const cl_image_format *image_format,
                                       size_t image_width,
                                       size_t image_height,
                                       size_t image_row_pitch,
                                       void *host_ptr,
                                       cl_int *errcode_ret,
                                       angle::ParamCapture *paramCapture);
void CaptureCreateImage2D_host_ptr(bool isCallValid,
                                   cl_context context,
                                   MemFlags flagsPacked,
                                   const cl_image_format *image_format,
                                   size_t image_width,
                                   size_t image_height,
                                   size_t image_row_pitch,
                                   void *host_ptr,
                                   cl_int *errcode_ret,
                                   angle::ParamCapture *paramCapture);
void CaptureCreateImage2D_errcode_ret(bool isCallValid,
                                      cl_context context,
                                      MemFlags flagsPacked,
                                      const cl_image_format *image_format,
                                      size_t image_width,
                                      size_t image_height,
                                      size_t image_row_pitch,
                                      void *host_ptr,
                                      cl_int *errcode_ret,
                                      angle::ParamCapture *paramCapture);
void CaptureCreateImage3D_image_format(bool isCallValid,
                                       cl_context context,
                                       MemFlags flagsPacked,
                                       const cl_image_format *image_format,
                                       size_t image_width,
                                       size_t image_height,
                                       size_t image_depth,
                                       size_t image_row_pitch,
                                       size_t image_slice_pitch,
                                       void *host_ptr,
                                       cl_int *errcode_ret,
                                       angle::ParamCapture *paramCapture);
void CaptureCreateImage3D_host_ptr(bool isCallValid,
                                   cl_context context,
                                   MemFlags flagsPacked,
                                   const cl_image_format *image_format,
                                   size_t image_width,
                                   size_t image_height,
                                   size_t image_depth,
                                   size_t image_row_pitch,
                                   size_t image_slice_pitch,
                                   void *host_ptr,
                                   cl_int *errcode_ret,
                                   angle::ParamCapture *paramCapture);
void CaptureCreateImage3D_errcode_ret(bool isCallValid,
                                      cl_context context,
                                      MemFlags flagsPacked,
                                      const cl_image_format *image_format,
                                      size_t image_width,
                                      size_t image_height,
                                      size_t image_depth,
                                      size_t image_row_pitch,
                                      size_t image_slice_pitch,
                                      void *host_ptr,
                                      cl_int *errcode_ret,
                                      angle::ParamCapture *paramCapture);
void CaptureEnqueueMarker_event(bool isCallValid,
                                cl_command_queue command_queue,
                                cl_event *event,
                                angle::ParamCapture *paramCapture);
void CaptureEnqueueWaitForEvents_event_list(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_uint num_events,
                                            const cl_event *event_list,
                                            angle::ParamCapture *paramCapture);
void CaptureGetExtensionFunctionAddress_func_name(bool isCallValid,
                                                  const char *func_name,
                                                  angle::ParamCapture *paramCapture);
void CaptureCreateCommandQueue_errcode_ret(bool isCallValid,
                                           cl_context context,
                                           cl_device_id device,
                                           CommandQueueProperties propertiesPacked,
                                           cl_int *errcode_ret,
                                           angle::ParamCapture *paramCapture);
void CaptureCreateSampler_errcode_ret(bool isCallValid,
                                      cl_context context,
                                      cl_bool normalized_coords,
                                      AddressingMode addressing_modePacked,
                                      FilterMode filter_modePacked,
                                      cl_int *errcode_ret,
                                      angle::ParamCapture *paramCapture);
void CaptureEnqueueTask_event_wait_list(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_kernel kernel,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        angle::ParamCapture *paramCapture);
void CaptureEnqueueTask_event(bool isCallValid,
                              cl_command_queue command_queue,
                              cl_kernel kernel,
                              cl_uint num_events_in_wait_list,
                              const cl_event *event_wait_list,
                              cl_event *event,
                              angle::ParamCapture *paramCapture);

// CL 1.1
void CaptureCreateSubBuffer_buffer_create_info(bool isCallValid,
                                               cl_mem buffer,
                                               MemFlags flagsPacked,
                                               cl_buffer_create_type buffer_create_type,
                                               const void *buffer_create_info,
                                               cl_int *errcode_ret,
                                               angle::ParamCapture *paramCapture);
void CaptureCreateSubBuffer_errcode_ret(bool isCallValid,
                                        cl_mem buffer,
                                        MemFlags flagsPacked,
                                        cl_buffer_create_type buffer_create_type,
                                        const void *buffer_create_info,
                                        cl_int *errcode_ret,
                                        angle::ParamCapture *paramCapture);
void CaptureSetMemObjectDestructorCallback_pfn_notify(
    bool isCallValid,
    cl_mem memobj,
    void(CL_CALLBACK *pfn_notify)(cl_mem memobj, void *user_data),
    void *user_data,
    angle::ParamCapture *paramCapture);
void CaptureSetMemObjectDestructorCallback_user_data(bool isCallValid,
                                                     cl_mem memobj,
                                                     void(CL_CALLBACK *pfn_notify)(cl_mem memobj,
                                                                                   void *user_data),
                                                     void *user_data,
                                                     angle::ParamCapture *paramCapture);
void CaptureCreateUserEvent_errcode_ret(bool isCallValid,
                                        cl_context context,
                                        cl_int *errcode_ret,
                                        angle::ParamCapture *paramCapture);
void CaptureSetEventCallback_pfn_notify(bool isCallValid,
                                        cl_event event,
                                        cl_int command_exec_callback_type,
                                        void(CL_CALLBACK *pfn_notify)(cl_event event,
                                                                      cl_int event_command_status,
                                                                      void *user_data),
                                        void *user_data,
                                        angle::ParamCapture *paramCapture);
void CaptureSetEventCallback_user_data(bool isCallValid,
                                       cl_event event,
                                       cl_int command_exec_callback_type,
                                       void(CL_CALLBACK *pfn_notify)(cl_event event,
                                                                     cl_int event_command_status,
                                                                     void *user_data),
                                       void *user_data,
                                       angle::ParamCapture *paramCapture);
void CaptureEnqueueReadBufferRect_buffer_origin(bool isCallValid,
                                                cl_command_queue command_queue,
                                                cl_mem buffer,
                                                cl_bool blocking_read,
                                                const size_t *buffer_origin,
                                                const size_t *host_origin,
                                                const size_t *region,
                                                size_t buffer_row_pitch,
                                                size_t buffer_slice_pitch,
                                                size_t host_row_pitch,
                                                size_t host_slice_pitch,
                                                void *ptr,
                                                cl_uint num_events_in_wait_list,
                                                const cl_event *event_wait_list,
                                                cl_event *event,
                                                angle::ParamCapture *paramCapture);
void CaptureEnqueueReadBufferRect_host_origin(bool isCallValid,
                                              cl_command_queue command_queue,
                                              cl_mem buffer,
                                              cl_bool blocking_read,
                                              const size_t *buffer_origin,
                                              const size_t *host_origin,
                                              const size_t *region,
                                              size_t buffer_row_pitch,
                                              size_t buffer_slice_pitch,
                                              size_t host_row_pitch,
                                              size_t host_slice_pitch,
                                              void *ptr,
                                              cl_uint num_events_in_wait_list,
                                              const cl_event *event_wait_list,
                                              cl_event *event,
                                              angle::ParamCapture *paramCapture);
void CaptureEnqueueReadBufferRect_region(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_mem buffer,
                                         cl_bool blocking_read,
                                         const size_t *buffer_origin,
                                         const size_t *host_origin,
                                         const size_t *region,
                                         size_t buffer_row_pitch,
                                         size_t buffer_slice_pitch,
                                         size_t host_row_pitch,
                                         size_t host_slice_pitch,
                                         void *ptr,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         angle::ParamCapture *paramCapture);
void CaptureEnqueueReadBufferRect_ptr(bool isCallValid,
                                      cl_command_queue command_queue,
                                      cl_mem buffer,
                                      cl_bool blocking_read,
                                      const size_t *buffer_origin,
                                      const size_t *host_origin,
                                      const size_t *region,
                                      size_t buffer_row_pitch,
                                      size_t buffer_slice_pitch,
                                      size_t host_row_pitch,
                                      size_t host_slice_pitch,
                                      void *ptr,
                                      cl_uint num_events_in_wait_list,
                                      const cl_event *event_wait_list,
                                      cl_event *event,
                                      angle::ParamCapture *paramCapture);
void CaptureEnqueueReadBufferRect_event_wait_list(bool isCallValid,
                                                  cl_command_queue command_queue,
                                                  cl_mem buffer,
                                                  cl_bool blocking_read,
                                                  const size_t *buffer_origin,
                                                  const size_t *host_origin,
                                                  const size_t *region,
                                                  size_t buffer_row_pitch,
                                                  size_t buffer_slice_pitch,
                                                  size_t host_row_pitch,
                                                  size_t host_slice_pitch,
                                                  void *ptr,
                                                  cl_uint num_events_in_wait_list,
                                                  const cl_event *event_wait_list,
                                                  cl_event *event,
                                                  angle::ParamCapture *paramCapture);
void CaptureEnqueueReadBufferRect_event(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_mem buffer,
                                        cl_bool blocking_read,
                                        const size_t *buffer_origin,
                                        const size_t *host_origin,
                                        const size_t *region,
                                        size_t buffer_row_pitch,
                                        size_t buffer_slice_pitch,
                                        size_t host_row_pitch,
                                        size_t host_slice_pitch,
                                        void *ptr,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteBufferRect_buffer_origin(bool isCallValid,
                                                 cl_command_queue command_queue,
                                                 cl_mem buffer,
                                                 cl_bool blocking_write,
                                                 const size_t *buffer_origin,
                                                 const size_t *host_origin,
                                                 const size_t *region,
                                                 size_t buffer_row_pitch,
                                                 size_t buffer_slice_pitch,
                                                 size_t host_row_pitch,
                                                 size_t host_slice_pitch,
                                                 const void *ptr,
                                                 cl_uint num_events_in_wait_list,
                                                 const cl_event *event_wait_list,
                                                 cl_event *event,
                                                 angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteBufferRect_host_origin(bool isCallValid,
                                               cl_command_queue command_queue,
                                               cl_mem buffer,
                                               cl_bool blocking_write,
                                               const size_t *buffer_origin,
                                               const size_t *host_origin,
                                               const size_t *region,
                                               size_t buffer_row_pitch,
                                               size_t buffer_slice_pitch,
                                               size_t host_row_pitch,
                                               size_t host_slice_pitch,
                                               const void *ptr,
                                               cl_uint num_events_in_wait_list,
                                               const cl_event *event_wait_list,
                                               cl_event *event,
                                               angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteBufferRect_region(bool isCallValid,
                                          cl_command_queue command_queue,
                                          cl_mem buffer,
                                          cl_bool blocking_write,
                                          const size_t *buffer_origin,
                                          const size_t *host_origin,
                                          const size_t *region,
                                          size_t buffer_row_pitch,
                                          size_t buffer_slice_pitch,
                                          size_t host_row_pitch,
                                          size_t host_slice_pitch,
                                          const void *ptr,
                                          cl_uint num_events_in_wait_list,
                                          const cl_event *event_wait_list,
                                          cl_event *event,
                                          angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteBufferRect_ptr(bool isCallValid,
                                       cl_command_queue command_queue,
                                       cl_mem buffer,
                                       cl_bool blocking_write,
                                       const size_t *buffer_origin,
                                       const size_t *host_origin,
                                       const size_t *region,
                                       size_t buffer_row_pitch,
                                       size_t buffer_slice_pitch,
                                       size_t host_row_pitch,
                                       size_t host_slice_pitch,
                                       const void *ptr,
                                       cl_uint num_events_in_wait_list,
                                       const cl_event *event_wait_list,
                                       cl_event *event,
                                       angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteBufferRect_event_wait_list(bool isCallValid,
                                                   cl_command_queue command_queue,
                                                   cl_mem buffer,
                                                   cl_bool blocking_write,
                                                   const size_t *buffer_origin,
                                                   const size_t *host_origin,
                                                   const size_t *region,
                                                   size_t buffer_row_pitch,
                                                   size_t buffer_slice_pitch,
                                                   size_t host_row_pitch,
                                                   size_t host_slice_pitch,
                                                   const void *ptr,
                                                   cl_uint num_events_in_wait_list,
                                                   const cl_event *event_wait_list,
                                                   cl_event *event,
                                                   angle::ParamCapture *paramCapture);
void CaptureEnqueueWriteBufferRect_event(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_mem buffer,
                                         cl_bool blocking_write,
                                         const size_t *buffer_origin,
                                         const size_t *host_origin,
                                         const size_t *region,
                                         size_t buffer_row_pitch,
                                         size_t buffer_slice_pitch,
                                         size_t host_row_pitch,
                                         size_t host_slice_pitch,
                                         const void *ptr,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyBufferRect_src_origin(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_mem src_buffer,
                                             cl_mem dst_buffer,
                                             const size_t *src_origin,
                                             const size_t *dst_origin,
                                             const size_t *region,
                                             size_t src_row_pitch,
                                             size_t src_slice_pitch,
                                             size_t dst_row_pitch,
                                             size_t dst_slice_pitch,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyBufferRect_dst_origin(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_mem src_buffer,
                                             cl_mem dst_buffer,
                                             const size_t *src_origin,
                                             const size_t *dst_origin,
                                             const size_t *region,
                                             size_t src_row_pitch,
                                             size_t src_slice_pitch,
                                             size_t dst_row_pitch,
                                             size_t dst_slice_pitch,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyBufferRect_region(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_mem src_buffer,
                                         cl_mem dst_buffer,
                                         const size_t *src_origin,
                                         const size_t *dst_origin,
                                         const size_t *region,
                                         size_t src_row_pitch,
                                         size_t src_slice_pitch,
                                         size_t dst_row_pitch,
                                         size_t dst_slice_pitch,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyBufferRect_event_wait_list(bool isCallValid,
                                                  cl_command_queue command_queue,
                                                  cl_mem src_buffer,
                                                  cl_mem dst_buffer,
                                                  const size_t *src_origin,
                                                  const size_t *dst_origin,
                                                  const size_t *region,
                                                  size_t src_row_pitch,
                                                  size_t src_slice_pitch,
                                                  size_t dst_row_pitch,
                                                  size_t dst_slice_pitch,
                                                  cl_uint num_events_in_wait_list,
                                                  const cl_event *event_wait_list,
                                                  cl_event *event,
                                                  angle::ParamCapture *paramCapture);
void CaptureEnqueueCopyBufferRect_event(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_mem src_buffer,
                                        cl_mem dst_buffer,
                                        const size_t *src_origin,
                                        const size_t *dst_origin,
                                        const size_t *region,
                                        size_t src_row_pitch,
                                        size_t src_slice_pitch,
                                        size_t dst_row_pitch,
                                        size_t dst_slice_pitch,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        angle::ParamCapture *paramCapture);

// CL 1.2
void CaptureCreateSubDevices_properties(bool isCallValid,
                                        cl_device_id in_device,
                                        const cl_device_partition_property *properties,
                                        cl_uint num_devices,
                                        cl_device_id *out_devices,
                                        cl_uint *num_devices_ret,
                                        angle::ParamCapture *paramCapture);
void CaptureCreateSubDevices_out_devices(bool isCallValid,
                                         cl_device_id in_device,
                                         const cl_device_partition_property *properties,
                                         cl_uint num_devices,
                                         cl_device_id *out_devices,
                                         cl_uint *num_devices_ret,
                                         angle::ParamCapture *paramCapture);
void CaptureCreateSubDevices_num_devices_ret(bool isCallValid,
                                             cl_device_id in_device,
                                             const cl_device_partition_property *properties,
                                             cl_uint num_devices,
                                             cl_device_id *out_devices,
                                             cl_uint *num_devices_ret,
                                             angle::ParamCapture *paramCapture);
void CaptureCreateImage_image_format(bool isCallValid,
                                     cl_context context,
                                     MemFlags flagsPacked,
                                     const cl_image_format *image_format,
                                     const cl_image_desc *image_desc,
                                     void *host_ptr,
                                     cl_int *errcode_ret,
                                     angle::ParamCapture *paramCapture);
void CaptureCreateImage_image_desc(bool isCallValid,
                                   cl_context context,
                                   MemFlags flagsPacked,
                                   const cl_image_format *image_format,
                                   const cl_image_desc *image_desc,
                                   void *host_ptr,
                                   cl_int *errcode_ret,
                                   angle::ParamCapture *paramCapture);
void CaptureCreateImage_host_ptr(bool isCallValid,
                                 cl_context context,
                                 MemFlags flagsPacked,
                                 const cl_image_format *image_format,
                                 const cl_image_desc *image_desc,
                                 void *host_ptr,
                                 cl_int *errcode_ret,
                                 angle::ParamCapture *paramCapture);
void CaptureCreateImage_errcode_ret(bool isCallValid,
                                    cl_context context,
                                    MemFlags flagsPacked,
                                    const cl_image_format *image_format,
                                    const cl_image_desc *image_desc,
                                    void *host_ptr,
                                    cl_int *errcode_ret,
                                    angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithBuiltInKernels_device_list(bool isCallValid,
                                                        cl_context context,
                                                        cl_uint num_devices,
                                                        const cl_device_id *device_list,
                                                        const char *kernel_names,
                                                        cl_int *errcode_ret,
                                                        angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithBuiltInKernels_kernel_names(bool isCallValid,
                                                         cl_context context,
                                                         cl_uint num_devices,
                                                         const cl_device_id *device_list,
                                                         const char *kernel_names,
                                                         cl_int *errcode_ret,
                                                         angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithBuiltInKernels_errcode_ret(bool isCallValid,
                                                        cl_context context,
                                                        cl_uint num_devices,
                                                        const cl_device_id *device_list,
                                                        const char *kernel_names,
                                                        cl_int *errcode_ret,
                                                        angle::ParamCapture *paramCapture);
void CaptureCompileProgram_device_list(bool isCallValid,
                                       cl_program program,
                                       cl_uint num_devices,
                                       const cl_device_id *device_list,
                                       const char *options,
                                       cl_uint num_input_headers,
                                       const cl_program *input_headers,
                                       const char **header_include_names,
                                       void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                     void *user_data),
                                       void *user_data,
                                       angle::ParamCapture *paramCapture);
void CaptureCompileProgram_options(bool isCallValid,
                                   cl_program program,
                                   cl_uint num_devices,
                                   const cl_device_id *device_list,
                                   const char *options,
                                   cl_uint num_input_headers,
                                   const cl_program *input_headers,
                                   const char **header_include_names,
                                   void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                 void *user_data),
                                   void *user_data,
                                   angle::ParamCapture *paramCapture);
void CaptureCompileProgram_input_headers(bool isCallValid,
                                         cl_program program,
                                         cl_uint num_devices,
                                         const cl_device_id *device_list,
                                         const char *options,
                                         cl_uint num_input_headers,
                                         const cl_program *input_headers,
                                         const char **header_include_names,
                                         void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                       void *user_data),
                                         void *user_data,
                                         angle::ParamCapture *paramCapture);
void CaptureCompileProgram_header_include_names(bool isCallValid,
                                                cl_program program,
                                                cl_uint num_devices,
                                                const cl_device_id *device_list,
                                                const char *options,
                                                cl_uint num_input_headers,
                                                const cl_program *input_headers,
                                                const char **header_include_names,
                                                void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                              void *user_data),
                                                void *user_data,
                                                angle::ParamCapture *paramCapture);
void CaptureCompileProgram_pfn_notify(bool isCallValid,
                                      cl_program program,
                                      cl_uint num_devices,
                                      const cl_device_id *device_list,
                                      const char *options,
                                      cl_uint num_input_headers,
                                      const cl_program *input_headers,
                                      const char **header_include_names,
                                      void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                    void *user_data),
                                      void *user_data,
                                      angle::ParamCapture *paramCapture);
void CaptureCompileProgram_user_data(bool isCallValid,
                                     cl_program program,
                                     cl_uint num_devices,
                                     const cl_device_id *device_list,
                                     const char *options,
                                     cl_uint num_input_headers,
                                     const cl_program *input_headers,
                                     const char **header_include_names,
                                     void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                   void *user_data),
                                     void *user_data,
                                     angle::ParamCapture *paramCapture);
void CaptureLinkProgram_device_list(bool isCallValid,
                                    cl_context context,
                                    cl_uint num_devices,
                                    const cl_device_id *device_list,
                                    const char *options,
                                    cl_uint num_input_programs,
                                    const cl_program *input_programs,
                                    void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                  void *user_data),
                                    void *user_data,
                                    cl_int *errcode_ret,
                                    angle::ParamCapture *paramCapture);
void CaptureLinkProgram_options(bool isCallValid,
                                cl_context context,
                                cl_uint num_devices,
                                const cl_device_id *device_list,
                                const char *options,
                                cl_uint num_input_programs,
                                const cl_program *input_programs,
                                void(CL_CALLBACK *pfn_notify)(cl_program program, void *user_data),
                                void *user_data,
                                cl_int *errcode_ret,
                                angle::ParamCapture *paramCapture);
void CaptureLinkProgram_input_programs(bool isCallValid,
                                       cl_context context,
                                       cl_uint num_devices,
                                       const cl_device_id *device_list,
                                       const char *options,
                                       cl_uint num_input_programs,
                                       const cl_program *input_programs,
                                       void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                     void *user_data),
                                       void *user_data,
                                       cl_int *errcode_ret,
                                       angle::ParamCapture *paramCapture);
void CaptureLinkProgram_pfn_notify(bool isCallValid,
                                   cl_context context,
                                   cl_uint num_devices,
                                   const cl_device_id *device_list,
                                   const char *options,
                                   cl_uint num_input_programs,
                                   const cl_program *input_programs,
                                   void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                 void *user_data),
                                   void *user_data,
                                   cl_int *errcode_ret,
                                   angle::ParamCapture *paramCapture);
void CaptureLinkProgram_user_data(bool isCallValid,
                                  cl_context context,
                                  cl_uint num_devices,
                                  const cl_device_id *device_list,
                                  const char *options,
                                  cl_uint num_input_programs,
                                  const cl_program *input_programs,
                                  void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                void *user_data),
                                  void *user_data,
                                  cl_int *errcode_ret,
                                  angle::ParamCapture *paramCapture);
void CaptureLinkProgram_errcode_ret(bool isCallValid,
                                    cl_context context,
                                    cl_uint num_devices,
                                    const cl_device_id *device_list,
                                    const char *options,
                                    cl_uint num_input_programs,
                                    const cl_program *input_programs,
                                    void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                  void *user_data),
                                    void *user_data,
                                    cl_int *errcode_ret,
                                    angle::ParamCapture *paramCapture);
void CaptureGetKernelArgInfo_param_value(bool isCallValid,
                                         cl_kernel kernel,
                                         cl_uint arg_index,
                                         KernelArgInfo param_namePacked,
                                         size_t param_value_size,
                                         void *param_value,
                                         size_t *param_value_size_ret,
                                         angle::ParamCapture *paramCapture);
void CaptureGetKernelArgInfo_param_value_size_ret(bool isCallValid,
                                                  cl_kernel kernel,
                                                  cl_uint arg_index,
                                                  KernelArgInfo param_namePacked,
                                                  size_t param_value_size,
                                                  void *param_value,
                                                  size_t *param_value_size_ret,
                                                  angle::ParamCapture *paramCapture);
void CaptureEnqueueFillBuffer_pattern(bool isCallValid,
                                      cl_command_queue command_queue,
                                      cl_mem buffer,
                                      const void *pattern,
                                      size_t pattern_size,
                                      size_t offset,
                                      size_t size,
                                      cl_uint num_events_in_wait_list,
                                      const cl_event *event_wait_list,
                                      cl_event *event,
                                      angle::ParamCapture *paramCapture);
void CaptureEnqueueFillBuffer_event_wait_list(bool isCallValid,
                                              cl_command_queue command_queue,
                                              cl_mem buffer,
                                              const void *pattern,
                                              size_t pattern_size,
                                              size_t offset,
                                              size_t size,
                                              cl_uint num_events_in_wait_list,
                                              const cl_event *event_wait_list,
                                              cl_event *event,
                                              angle::ParamCapture *paramCapture);
void CaptureEnqueueFillBuffer_event(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem buffer,
                                    const void *pattern,
                                    size_t pattern_size,
                                    size_t offset,
                                    size_t size,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    angle::ParamCapture *paramCapture);
void CaptureEnqueueFillImage_fill_color(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_mem image,
                                        const void *fill_color,
                                        const size_t *origin,
                                        const size_t *region,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        angle::ParamCapture *paramCapture);
void CaptureEnqueueFillImage_origin(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem image,
                                    const void *fill_color,
                                    const size_t *origin,
                                    const size_t *region,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    angle::ParamCapture *paramCapture);
void CaptureEnqueueFillImage_region(bool isCallValid,
                                    cl_command_queue command_queue,
                                    cl_mem image,
                                    const void *fill_color,
                                    const size_t *origin,
                                    const size_t *region,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    angle::ParamCapture *paramCapture);
void CaptureEnqueueFillImage_event_wait_list(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_mem image,
                                             const void *fill_color,
                                             const size_t *origin,
                                             const size_t *region,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             angle::ParamCapture *paramCapture);
void CaptureEnqueueFillImage_event(bool isCallValid,
                                   cl_command_queue command_queue,
                                   cl_mem image,
                                   const void *fill_color,
                                   const size_t *origin,
                                   const size_t *region,
                                   cl_uint num_events_in_wait_list,
                                   const cl_event *event_wait_list,
                                   cl_event *event,
                                   angle::ParamCapture *paramCapture);
void CaptureEnqueueMigrateMemObjects_mem_objects(bool isCallValid,
                                                 cl_command_queue command_queue,
                                                 cl_uint num_mem_objects,
                                                 const cl_mem *mem_objects,
                                                 MemMigrationFlags flagsPacked,
                                                 cl_uint num_events_in_wait_list,
                                                 const cl_event *event_wait_list,
                                                 cl_event *event,
                                                 angle::ParamCapture *paramCapture);
void CaptureEnqueueMigrateMemObjects_event_wait_list(bool isCallValid,
                                                     cl_command_queue command_queue,
                                                     cl_uint num_mem_objects,
                                                     const cl_mem *mem_objects,
                                                     MemMigrationFlags flagsPacked,
                                                     cl_uint num_events_in_wait_list,
                                                     const cl_event *event_wait_list,
                                                     cl_event *event,
                                                     angle::ParamCapture *paramCapture);
void CaptureEnqueueMigrateMemObjects_event(bool isCallValid,
                                           cl_command_queue command_queue,
                                           cl_uint num_mem_objects,
                                           const cl_mem *mem_objects,
                                           MemMigrationFlags flagsPacked,
                                           cl_uint num_events_in_wait_list,
                                           const cl_event *event_wait_list,
                                           cl_event *event,
                                           angle::ParamCapture *paramCapture);
void CaptureEnqueueMarkerWithWaitList_event_wait_list(bool isCallValid,
                                                      cl_command_queue command_queue,
                                                      cl_uint num_events_in_wait_list,
                                                      const cl_event *event_wait_list,
                                                      cl_event *event,
                                                      angle::ParamCapture *paramCapture);
void CaptureEnqueueMarkerWithWaitList_event(bool isCallValid,
                                            cl_command_queue command_queue,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            angle::ParamCapture *paramCapture);
void CaptureEnqueueBarrierWithWaitList_event_wait_list(bool isCallValid,
                                                       cl_command_queue command_queue,
                                                       cl_uint num_events_in_wait_list,
                                                       const cl_event *event_wait_list,
                                                       cl_event *event,
                                                       angle::ParamCapture *paramCapture);
void CaptureEnqueueBarrierWithWaitList_event(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             angle::ParamCapture *paramCapture);
void CaptureGetExtensionFunctionAddressForPlatform_func_name(bool isCallValid,
                                                             cl_platform_id platform,
                                                             const char *func_name,
                                                             angle::ParamCapture *paramCapture);

// CL 2.0
void CaptureCreateCommandQueueWithProperties_properties(bool isCallValid,
                                                        cl_context context,
                                                        cl_device_id device,
                                                        const cl_queue_properties *properties,
                                                        cl_int *errcode_ret,
                                                        angle::ParamCapture *paramCapture);
void CaptureCreateCommandQueueWithProperties_errcode_ret(bool isCallValid,
                                                         cl_context context,
                                                         cl_device_id device,
                                                         const cl_queue_properties *properties,
                                                         cl_int *errcode_ret,
                                                         angle::ParamCapture *paramCapture);
void CaptureCreatePipe_properties(bool isCallValid,
                                  cl_context context,
                                  MemFlags flagsPacked,
                                  cl_uint pipe_packet_size,
                                  cl_uint pipe_max_packets,
                                  const cl_pipe_properties *properties,
                                  cl_int *errcode_ret,
                                  angle::ParamCapture *paramCapture);
void CaptureCreatePipe_errcode_ret(bool isCallValid,
                                   cl_context context,
                                   MemFlags flagsPacked,
                                   cl_uint pipe_packet_size,
                                   cl_uint pipe_max_packets,
                                   const cl_pipe_properties *properties,
                                   cl_int *errcode_ret,
                                   angle::ParamCapture *paramCapture);
void CaptureGetPipeInfo_param_value(bool isCallValid,
                                    cl_mem pipe,
                                    PipeInfo param_namePacked,
                                    size_t param_value_size,
                                    void *param_value,
                                    size_t *param_value_size_ret,
                                    angle::ParamCapture *paramCapture);
void CaptureGetPipeInfo_param_value_size_ret(bool isCallValid,
                                             cl_mem pipe,
                                             PipeInfo param_namePacked,
                                             size_t param_value_size,
                                             void *param_value,
                                             size_t *param_value_size_ret,
                                             angle::ParamCapture *paramCapture);
void CaptureSVMFree_svm_pointer(bool isCallValid,
                                cl_context context,
                                void *svm_pointer,
                                angle::ParamCapture *paramCapture);
void CaptureCreateSamplerWithProperties_sampler_properties(
    bool isCallValid,
    cl_context context,
    const cl_sampler_properties *sampler_properties,
    cl_int *errcode_ret,
    angle::ParamCapture *paramCapture);
void CaptureCreateSamplerWithProperties_errcode_ret(bool isCallValid,
                                                    cl_context context,
                                                    const cl_sampler_properties *sampler_properties,
                                                    cl_int *errcode_ret,
                                                    angle::ParamCapture *paramCapture);
void CaptureSetKernelArgSVMPointer_arg_value(bool isCallValid,
                                             cl_kernel kernel,
                                             cl_uint arg_index,
                                             const void *arg_value,
                                             angle::ParamCapture *paramCapture);
void CaptureSetKernelExecInfo_param_value(bool isCallValid,
                                          cl_kernel kernel,
                                          KernelExecInfo param_namePacked,
                                          size_t param_value_size,
                                          const void *param_value,
                                          angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMFree_svm_pointers(bool isCallValid,
                                        cl_command_queue command_queue,
                                        cl_uint num_svm_pointers,
                                        void *svm_pointers[],
                                        void(CL_CALLBACK *pfn_free_func)(cl_command_queue queue,
                                                                         cl_uint num_svm_pointers,
                                                                         void *svm_pointers[],
                                                                         void *user_data),
                                        void *user_data,
                                        cl_uint num_events_in_wait_list,
                                        const cl_event *event_wait_list,
                                        cl_event *event,
                                        angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMFree_pfn_free_func(bool isCallValid,
                                         cl_command_queue command_queue,
                                         cl_uint num_svm_pointers,
                                         void *svm_pointers[],
                                         void(CL_CALLBACK *pfn_free_func)(cl_command_queue queue,
                                                                          cl_uint num_svm_pointers,
                                                                          void *svm_pointers[],
                                                                          void *user_data),
                                         void *user_data,
                                         cl_uint num_events_in_wait_list,
                                         const cl_event *event_wait_list,
                                         cl_event *event,
                                         angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMFree_user_data(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_uint num_svm_pointers,
                                     void *svm_pointers[],
                                     void(CL_CALLBACK *pfn_free_func)(cl_command_queue queue,
                                                                      cl_uint num_svm_pointers,
                                                                      void *svm_pointers[],
                                                                      void *user_data),
                                     void *user_data,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMFree_event_wait_list(
    bool isCallValid,
    cl_command_queue command_queue,
    cl_uint num_svm_pointers,
    void *svm_pointers[],
    void(CL_CALLBACK *pfn_free_func)(cl_command_queue queue,
                                     cl_uint num_svm_pointers,
                                     void *svm_pointers[],
                                     void *user_data),
    void *user_data,
    cl_uint num_events_in_wait_list,
    const cl_event *event_wait_list,
    cl_event *event,
    angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMFree_event(bool isCallValid,
                                 cl_command_queue command_queue,
                                 cl_uint num_svm_pointers,
                                 void *svm_pointers[],
                                 void(CL_CALLBACK *pfn_free_func)(cl_command_queue queue,
                                                                  cl_uint num_svm_pointers,
                                                                  void *svm_pointers[],
                                                                  void *user_data),
                                 void *user_data,
                                 cl_uint num_events_in_wait_list,
                                 const cl_event *event_wait_list,
                                 cl_event *event,
                                 angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMemcpy_dst_ptr(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_bool blocking_copy,
                                     void *dst_ptr,
                                     const void *src_ptr,
                                     size_t size,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMemcpy_src_ptr(bool isCallValid,
                                     cl_command_queue command_queue,
                                     cl_bool blocking_copy,
                                     void *dst_ptr,
                                     const void *src_ptr,
                                     size_t size,
                                     cl_uint num_events_in_wait_list,
                                     const cl_event *event_wait_list,
                                     cl_event *event,
                                     angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMemcpy_event_wait_list(bool isCallValid,
                                             cl_command_queue command_queue,
                                             cl_bool blocking_copy,
                                             void *dst_ptr,
                                             const void *src_ptr,
                                             size_t size,
                                             cl_uint num_events_in_wait_list,
                                             const cl_event *event_wait_list,
                                             cl_event *event,
                                             angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMemcpy_event(bool isCallValid,
                                   cl_command_queue command_queue,
                                   cl_bool blocking_copy,
                                   void *dst_ptr,
                                   const void *src_ptr,
                                   size_t size,
                                   cl_uint num_events_in_wait_list,
                                   const cl_event *event_wait_list,
                                   cl_event *event,
                                   angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMemFill_svm_ptr(bool isCallValid,
                                      cl_command_queue command_queue,
                                      void *svm_ptr,
                                      const void *pattern,
                                      size_t pattern_size,
                                      size_t size,
                                      cl_uint num_events_in_wait_list,
                                      const cl_event *event_wait_list,
                                      cl_event *event,
                                      angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMemFill_pattern(bool isCallValid,
                                      cl_command_queue command_queue,
                                      void *svm_ptr,
                                      const void *pattern,
                                      size_t pattern_size,
                                      size_t size,
                                      cl_uint num_events_in_wait_list,
                                      const cl_event *event_wait_list,
                                      cl_event *event,
                                      angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMemFill_event_wait_list(bool isCallValid,
                                              cl_command_queue command_queue,
                                              void *svm_ptr,
                                              const void *pattern,
                                              size_t pattern_size,
                                              size_t size,
                                              cl_uint num_events_in_wait_list,
                                              const cl_event *event_wait_list,
                                              cl_event *event,
                                              angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMemFill_event(bool isCallValid,
                                    cl_command_queue command_queue,
                                    void *svm_ptr,
                                    const void *pattern,
                                    size_t pattern_size,
                                    size_t size,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMap_svm_ptr(bool isCallValid,
                                  cl_command_queue command_queue,
                                  cl_bool blocking_map,
                                  MapFlags flagsPacked,
                                  void *svm_ptr,
                                  size_t size,
                                  cl_uint num_events_in_wait_list,
                                  const cl_event *event_wait_list,
                                  cl_event *event,
                                  angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMap_event_wait_list(bool isCallValid,
                                          cl_command_queue command_queue,
                                          cl_bool blocking_map,
                                          MapFlags flagsPacked,
                                          void *svm_ptr,
                                          size_t size,
                                          cl_uint num_events_in_wait_list,
                                          const cl_event *event_wait_list,
                                          cl_event *event,
                                          angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMap_event(bool isCallValid,
                                cl_command_queue command_queue,
                                cl_bool blocking_map,
                                MapFlags flagsPacked,
                                void *svm_ptr,
                                size_t size,
                                cl_uint num_events_in_wait_list,
                                const cl_event *event_wait_list,
                                cl_event *event,
                                angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMUnmap_svm_ptr(bool isCallValid,
                                    cl_command_queue command_queue,
                                    void *svm_ptr,
                                    cl_uint num_events_in_wait_list,
                                    const cl_event *event_wait_list,
                                    cl_event *event,
                                    angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMUnmap_event_wait_list(bool isCallValid,
                                            cl_command_queue command_queue,
                                            void *svm_ptr,
                                            cl_uint num_events_in_wait_list,
                                            const cl_event *event_wait_list,
                                            cl_event *event,
                                            angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMUnmap_event(bool isCallValid,
                                  cl_command_queue command_queue,
                                  void *svm_ptr,
                                  cl_uint num_events_in_wait_list,
                                  const cl_event *event_wait_list,
                                  cl_event *event,
                                  angle::ParamCapture *paramCapture);

// CL 2.1
void CaptureGetDeviceAndHostTimer_device_timestamp(bool isCallValid,
                                                   cl_device_id device,
                                                   cl_ulong *device_timestamp,
                                                   cl_ulong *host_timestamp,
                                                   angle::ParamCapture *paramCapture);
void CaptureGetDeviceAndHostTimer_host_timestamp(bool isCallValid,
                                                 cl_device_id device,
                                                 cl_ulong *device_timestamp,
                                                 cl_ulong *host_timestamp,
                                                 angle::ParamCapture *paramCapture);
void CaptureGetHostTimer_host_timestamp(bool isCallValid,
                                        cl_device_id device,
                                        cl_ulong *host_timestamp,
                                        angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithIL_il(bool isCallValid,
                                   cl_context context,
                                   const void *il,
                                   size_t length,
                                   cl_int *errcode_ret,
                                   angle::ParamCapture *paramCapture);
void CaptureCreateProgramWithIL_errcode_ret(bool isCallValid,
                                            cl_context context,
                                            const void *il,
                                            size_t length,
                                            cl_int *errcode_ret,
                                            angle::ParamCapture *paramCapture);
void CaptureCloneKernel_errcode_ret(bool isCallValid,
                                    cl_kernel source_kernel,
                                    cl_int *errcode_ret,
                                    angle::ParamCapture *paramCapture);
void CaptureGetKernelSubGroupInfo_input_value(bool isCallValid,
                                              cl_kernel kernel,
                                              cl_device_id device,
                                              KernelSubGroupInfo param_namePacked,
                                              size_t input_value_size,
                                              const void *input_value,
                                              size_t param_value_size,
                                              void *param_value,
                                              size_t *param_value_size_ret,
                                              angle::ParamCapture *paramCapture);
void CaptureGetKernelSubGroupInfo_param_value(bool isCallValid,
                                              cl_kernel kernel,
                                              cl_device_id device,
                                              KernelSubGroupInfo param_namePacked,
                                              size_t input_value_size,
                                              const void *input_value,
                                              size_t param_value_size,
                                              void *param_value,
                                              size_t *param_value_size_ret,
                                              angle::ParamCapture *paramCapture);
void CaptureGetKernelSubGroupInfo_param_value_size_ret(bool isCallValid,
                                                       cl_kernel kernel,
                                                       cl_device_id device,
                                                       KernelSubGroupInfo param_namePacked,
                                                       size_t input_value_size,
                                                       const void *input_value,
                                                       size_t param_value_size,
                                                       void *param_value,
                                                       size_t *param_value_size_ret,
                                                       angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMigrateMem_svm_pointers(bool isCallValid,
                                              cl_command_queue command_queue,
                                              cl_uint num_svm_pointers,
                                              const void **svm_pointers,
                                              const size_t *sizes,
                                              MemMigrationFlags flagsPacked,
                                              cl_uint num_events_in_wait_list,
                                              const cl_event *event_wait_list,
                                              cl_event *event,
                                              angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMigrateMem_sizes(bool isCallValid,
                                       cl_command_queue command_queue,
                                       cl_uint num_svm_pointers,
                                       const void **svm_pointers,
                                       const size_t *sizes,
                                       MemMigrationFlags flagsPacked,
                                       cl_uint num_events_in_wait_list,
                                       const cl_event *event_wait_list,
                                       cl_event *event,
                                       angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMigrateMem_event_wait_list(bool isCallValid,
                                                 cl_command_queue command_queue,
                                                 cl_uint num_svm_pointers,
                                                 const void **svm_pointers,
                                                 const size_t *sizes,
                                                 MemMigrationFlags flagsPacked,
                                                 cl_uint num_events_in_wait_list,
                                                 const cl_event *event_wait_list,
                                                 cl_event *event,
                                                 angle::ParamCapture *paramCapture);
void CaptureEnqueueSVMMigrateMem_event(bool isCallValid,
                                       cl_command_queue command_queue,
                                       cl_uint num_svm_pointers,
                                       const void **svm_pointers,
                                       const size_t *sizes,
                                       MemMigrationFlags flagsPacked,
                                       cl_uint num_events_in_wait_list,
                                       const cl_event *event_wait_list,
                                       cl_event *event,
                                       angle::ParamCapture *paramCapture);

// CL 2.2
void CaptureSetProgramReleaseCallback_pfn_notify(bool isCallValid,
                                                 cl_program program,
                                                 void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                               void *user_data),
                                                 void *user_data,
                                                 angle::ParamCapture *paramCapture);
void CaptureSetProgramReleaseCallback_user_data(bool isCallValid,
                                                cl_program program,
                                                void(CL_CALLBACK *pfn_notify)(cl_program program,
                                                                              void *user_data),
                                                void *user_data,
                                                angle::ParamCapture *paramCapture);
void CaptureSetProgramSpecializationConstant_spec_value(bool isCallValid,
                                                        cl_program program,
                                                        cl_uint spec_id,
                                                        size_t spec_size,
                                                        const void *spec_value,
                                                        angle::ParamCapture *paramCapture);

// CL 3.0
void CaptureSetContextDestructorCallback_pfn_notify(
    bool isCallValid,
    cl_context context,
    void(CL_CALLBACK *pfn_notify)(cl_context context, void *user_data),
    void *user_data,
    angle::ParamCapture *paramCapture);
void CaptureSetContextDestructorCallback_user_data(bool isCallValid,
                                                   cl_context context,
                                                   void(CL_CALLBACK *pfn_notify)(cl_context context,
                                                                                 void *user_data),
                                                   void *user_data,
                                                   angle::ParamCapture *paramCapture);
void CaptureCreateBufferWithProperties_properties(bool isCallValid,
                                                  cl_context context,
                                                  const cl_mem_properties *properties,
                                                  MemFlags flagsPacked,
                                                  size_t size,
                                                  void *host_ptr,
                                                  cl_int *errcode_ret,
                                                  angle::ParamCapture *paramCapture);
void CaptureCreateBufferWithProperties_host_ptr(bool isCallValid,
                                                cl_context context,
                                                const cl_mem_properties *properties,
                                                MemFlags flagsPacked,
                                                size_t size,
                                                void *host_ptr,
                                                cl_int *errcode_ret,
                                                angle::ParamCapture *paramCapture);
void CaptureCreateBufferWithProperties_errcode_ret(bool isCallValid,
                                                   cl_context context,
                                                   const cl_mem_properties *properties,
                                                   MemFlags flagsPacked,
                                                   size_t size,
                                                   void *host_ptr,
                                                   cl_int *errcode_ret,
                                                   angle::ParamCapture *paramCapture);
void CaptureCreateImageWithProperties_properties(bool isCallValid,
                                                 cl_context context,
                                                 const cl_mem_properties *properties,
                                                 MemFlags flagsPacked,
                                                 const cl_image_format *image_format,
                                                 const cl_image_desc *image_desc,
                                                 void *host_ptr,
                                                 cl_int *errcode_ret,
                                                 angle::ParamCapture *paramCapture);
void CaptureCreateImageWithProperties_image_format(bool isCallValid,
                                                   cl_context context,
                                                   const cl_mem_properties *properties,
                                                   MemFlags flagsPacked,
                                                   const cl_image_format *image_format,
                                                   const cl_image_desc *image_desc,
                                                   void *host_ptr,
                                                   cl_int *errcode_ret,
                                                   angle::ParamCapture *paramCapture);
void CaptureCreateImageWithProperties_image_desc(bool isCallValid,
                                                 cl_context context,
                                                 const cl_mem_properties *properties,
                                                 MemFlags flagsPacked,
                                                 const cl_image_format *image_format,
                                                 const cl_image_desc *image_desc,
                                                 void *host_ptr,
                                                 cl_int *errcode_ret,
                                                 angle::ParamCapture *paramCapture);
void CaptureCreateImageWithProperties_host_ptr(bool isCallValid,
                                               cl_context context,
                                               const cl_mem_properties *properties,
                                               MemFlags flagsPacked,
                                               const cl_image_format *image_format,
                                               const cl_image_desc *image_desc,
                                               void *host_ptr,
                                               cl_int *errcode_ret,
                                               angle::ParamCapture *paramCapture);
void CaptureCreateImageWithProperties_errcode_ret(bool isCallValid,
                                                  cl_context context,
                                                  const cl_mem_properties *properties,
                                                  MemFlags flagsPacked,
                                                  const cl_image_format *image_format,
                                                  const cl_image_desc *image_desc,
                                                  void *host_ptr,
                                                  cl_int *errcode_ret,
                                                  angle::ParamCapture *paramCapture);

// cl_khr_icd
void CaptureIcdGetPlatformIDsKHR_platforms(bool isCallValid,
                                           cl_uint num_entries,
                                           cl_platform_id *platforms,
                                           cl_uint *num_platforms,
                                           angle::ParamCapture *paramCapture);
void CaptureIcdGetPlatformIDsKHR_num_platforms(bool isCallValid,
                                               cl_uint num_entries,
                                               cl_platform_id *platforms,
                                               cl_uint *num_platforms,
                                               angle::ParamCapture *paramCapture);
}  // namespace cl

#endif  // LIBANGLE_CAPTURE_CL_AUTOGEN_H_
