# 2024-06-23 Triage Log

Mostly a number of improvements driven by [MIR inliner improvements], with a small number
benchmarks having a significant regression due to improvements in
[sort algorithms], which are runtime improvements at the cost of usually slight or
neutral compile time regressions, with outliers in a few cases.

[MIR inliner improvements]: https://github.com/rust-lang/rust/pull/126578
[sort algorithms]: https://github.com/rust-lang/rust/pull/124032

Triage done by **@simulacrum**.
Revision range: [c2932aaf..c3d7fb39](https://perf.rust-lang.org/?start=c2932aaf9d20acbc9259c762f1a06f8767c6f13f&end=c3d7fb398569407350abe044e786bc7890c90397&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.6%  | [0.2%, 16.4%]  | 36    |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [0.1%, 5.0%]   | 31    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.6%, -0.2%] | 184   |
| Improvements ✅ <br /> (secondary) | -0.9% | [-3.4%, -0.3%] | 138   |
| All ❌✅ (primary)                 | -0.2% | [-1.6%, 16.4%] | 220   |


4 Regressions, 5 Improvements, 3 Mixed; 2 of them in rollups
48 artifact comparisons made in total

#### Regressions

Rollup of 10 pull requests [#126655](https://github.com/rust-lang/rust/pull/126655) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4e63822fc4e2ca675dd28bb3f332f7fd4f3f8126&end=a1ca449981e3b8442e358026437b7bedb9a1458e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.3%] | 6     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.2%, 0.9%] | 8     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.3%] | 6     |

Slight instruction count regressions, but mostly in somewhat noisy benchmarks.
It looks like performance went back to previous levels in the next few commits.

Replace sort implementations [#124032](https://github.com/rust-lang/rust/pull/124032) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=433355166d769afc9c19f761cc7efc4d152e9a2c&end=684b3553f70148ded97a80371c2405984d4f6aa7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.1%  | [0.2%, 18.0%]  | 51    |
| Regressions ❌ <br /> (secondary)  | 1.6%  | [0.4%, 3.9%]   | 8     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 2.0%  | [-0.3%, 18.0%] | 52    |

This change was extensively benchmarked, and the regressions were known ahead
of time. Runtime improvements are considered worth the regressions, which are
limited to just a few benchmarks. (Extensive effort was also put in to minimize
the compile time and binary size costs).

Properly gate `safe` keyword in pre-expansion [#126757](https://github.com/rust-lang/rust/pull/126757) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7a08f84627ff3035de4d66ff3209e5fc93165dcb&end=4e6de37349c7838df095b085a2640cb6a007c96a&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.3%] | 4     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.3%] | 4     |

Looks like a minimal regression (maybe spurious/bimodality) and the change is
clearly needed. Marking as triaged.

 Generalize `{Rc,Arc}::make_mut()` to unsized types. [#116113](https://github.com/rust-lang/rust/pull/116113) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ac47dbad504b892bc0f3be8fa097537c6e0544a3&end=f944afe3807104803976484e7ee3aff49b6ac070&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.3%, 2.2%] | 13    |
| Regressions ❌ <br /> (secondary)  | 0.9% | [0.9%, 0.9%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.3%, 2.2%] | 13    |

Regressions are mostly in doc benchmarks, seem likely to be just new docs due
to extra stuff in the standard library.

#### Improvements

Migrate `extern-flag-fun`, `incremental-debugger-visualiser` and `incremental-session-fail` `run-make` tests to `rmake.rs` [#126490](https://github.com/rust-lang/rust/pull/126490) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c2932aaf9d20acbc9259c762f1a06f8767c6f13f&end=67cfc3a558a54e351d14120099bf3158812b4130&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.3%] | 6     |


Rework `feature(precise_capturing)` to represent `use<...>` as a syntactical bound [#126049](https://github.com/rust-lang/rust/pull/126049) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f873ae029e3ee2bbb8bc70a7ef3f1a06c22b0eac&end=c1f62a7c35349438ea9728abbe1bcf1cebd426b7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.2%] | 12    |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 7     |


Fix duplicated attributes on nonterminal expressions [#126678](https://github.com/rust-lang/rust/pull/126678) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3186d17d56f9803b739a2c0aabd23aafd8791485&end=894f7a4ba6554d3797404bbf550d9919df060b97&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-0.7%, -0.6%] | 3     |
| All ❌✅ (primary)                 | -0.4% | [-0.5%, -0.2%] | 7     |


Trying to address an incremental compilation issues [#126409](https://github.com/rust-lang/rust/pull/126409) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1208eddaff59c98e37574c860de6f68aa404958f&end=1d96de2a20e963abb8923dfa3c6175517dfb9d2c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 21    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.2%] | 15    |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 21    |


Rollup of 3 pull requests [#126838](https://github.com/rust-lang/rust/pull/126838) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f944afe3807104803976484e7ee3aff49b6ac070&end=a0f01c3c1067aecb3d1ad88621bb4d63d0a2d289&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.9%, -0.2%] | 50    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.9%, -0.2%] | 19    |
| All ❌✅ (primary)                 | -0.4% | [-0.9%, -0.2%] | 50    |


#### Mixed

[perf] More span update benchmarking [#126591](https://github.com/rust-lang/rust/pull/126591) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=67cfc3a558a54e351d14120099bf3158812b4130&end=737e42308c6e957575692965d73b17937f936f28&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.4%]   | 5     |
| Regressions ❌ <br /> (secondary)  | 2.3%  | [1.4%, 3.6%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.2%] | 14    |
| All ❌✅ (primary)                 | 0.2%  | [-0.3%, 0.4%]  | 6     |

Triaged to be mostly just inlining noise:
https://github.com/rust-lang/rust/pull/126591#issuecomment-2175875210

Account for things that optimize out in inlining costs [#126578](https://github.com/rust-lang/rust/pull/126578) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a9c8887c7d548abc6c3e87f7d6fa02a0e95880bd&end=7a08f84627ff3035de4d66ff3209e5fc93165dcb&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4%  | [0.4%, 2.0%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [0.3%, 4.1%]   | 16    |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.5%, -0.2%] | 183   |
| Improvements ✅ <br /> (secondary) | -0.9% | [-4.6%, -0.2%] | 121   |
| All ❌✅ (primary)                 | -0.5% | [-1.5%, 2.0%]  | 189   |

Mostly an improvement for the majority of benchmarks, including some slight runtime improvements.

More ptr metadata gvn [#126541](https://github.com/rust-lang/rust/pull/126541) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4e6de37349c7838df095b085a2640cb6a007c96a&end=e32ea4822ba3f7c9054a7fb5345232388cc50c4b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.4%, -0.6%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.6% | [-1.4%, 0.2%]  | 3     |

Slight improvements on `full` builds, slight regression in incremental for
cargo. In general fairly neutral, only a few benchmarks affected.
